/*! @mainpage Core Plot
 *
 *  @section intro Introduction
 *
 *  Core Plot is a 2D plotting framework for Mac OS X and iOS.
 *  It is highly customizable and capable of drawing many types of plots.
 *  See the <a href="https://github.com/core-plot/core-plot/wiki/Example-Graphs">Example Graphs</a>
 *  wiki page and the <a href="https://github.com/core-plot/core-plot/tree/master/examples">example applications</a>
 *  for examples of some of its capabilities.
 *
 *  @section start Getting Started
 *
 *  See the <a href="https://github.com/core-plot/core-plot/wiki/High-Level-Design-Overview">High Level Design Overview</a>
 *  wiki for an overview of Core Plot's architecture and the
 *  <a href="http://code.google.com/p/core-plot/wiki/UsingCorePlotInApplications">Using Core Plot in an Application</a>
 *  wiki for information on how to use Core Plot in your own application.
 *
 *  @section documentation Documentation
 *
 *  Documentation of the Core Plot API and high-level architecture can be found in the following places:
 *
 *  - <a href="https://github.com/core-plot/core-plot/blob/master/documentation/changelog.markdown">Change log</a>
 *  - <a href="http://core-plot.github.io/MacOS/index.html">API documentation</a> for Mac
 *  - <a href="http://core-plot.github.io/iOS/index.html">API documentation</a> for iOS
 *  - API documentation built with <a href="http://www.doxygen.org/">Doxygen</a> and installed locally in Xcode
 *  (see the <a href="https://github.com/core-plot/core-plot/blob/master/READMEs/README%20for%20Docs%20Install.md">instructions</a>
 *  in the <strong>READMEs</strong> folder for details)
 *  - <a href="https://github.com/core-plot/core-plot/wiki">Project Wiki</a> on GitHub
 *  - <a href="https://github.com/core-plot/core-plot/tree/master/documentation">Documentation</a> folder in the code repository
 *
 *  @section wheretoaskforhelp Where to Ask For Help
 *
 *  @subsection qasites Q&A Sites
 *
 *  - <a href="http://groups.google.com/group/coreplot-discuss">Core Plot</a> Google Group
 *  - Stackoverflow.com <a href="http://stackoverflow.com/questions/tagged/core-plot">core-plot tag</a>
 *
 *  @subsection socialnetworks Social Networks
 *
 *  - <a href="https://twitter.com/CorePlot">Twitter</a>
 *  - <a href="https://alpha.app.net/coreplot">App.net</a>; Subscribe to the <a href="https://app.net/c/2rw2">Announcements</a> broadcast.
 *
 *  @section contributingtocoreplot Contributing to Core Plot
 *
 *  Core Plot is an open source project hosted on <a href="https://github.com/core-plot">GitHub</a>.
 *  There are two code repositories under the main project:
 *
 *  - <a href="https://github.com/core-plot/core-plot">core-plot</a>: This is main code repository with the framework and all examples.
 *  This is where you will find the release packages, wiki pages, and issue tracker.
 *  - <a href="https://github.com/core-plot/core-plot.github.io">core-plot.github.io</a>: This is the HTML API documentation.
 *  You can view the pages online at <a href="">http://core-plot.github.io</a>.
 *
 *  @subsection codingstandards Coding Standards
 *
 *  Everyone has a their own preferred coding style, and no one way can be considered right.
 *  Nonetheless, in a project like Core Plot, with many developers contributing, it is worthwhile
 *  defining a set of basic coding standards to prevent a mishmash of different styles which can
 *  become frustrating when navigating the code base. See the file
 *  <a href="https://github.com/core-plot/core-plot/blob/master/documentation/Coding%20Style.markdown">Coding Style.markdown</a>
 *  found in the <a href="https://github.com/core-plot/core-plot/tree/master/documentation">documentation</a>
 *  directory of the project source for specific guidelines.
 *
 *  Core Plot includes a <a href="https://github.com/core-plot/core-plot/blob/master/scripts/format_core_plot.sh">script</a>
 *  to run <a href="http://uncrustify.sourceforge.net">Uncrustify</a> on the source code to standardize the formatting.
 *  All source code will be formatted with this tool before being committed to the Core Plot repository.
 *
 *  @subsection testing Testing
 *
 *  Because Core Plot is intended to be used in scientific, financial, and other domains where correctness is paramount,
 *  unit testing is integrated into the framework. Good test coverage protects developers from introducing accidental
 *  regressions and frees them to experiment and refactor without fear of breaking things. See the
 *  <a href="https://github.com/core-plot/core-plot/wiki/Unit-Testing">unit testing</a> wiki page for instructions
 *  on how to build unit tests for any new code you add to the project.
 */
