//
//  GlobalMethods.h
//  SamKnows
//
//  Copyright (c) 2011-2014 SamKnows Limited. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <mach/mach.h>

#define SERVER_LIST_CONFIG_FILE_NAME @"testServer.json"
#define SCENARIO_CONFIG_FILE_NAME @"scenario.json"
#define LOCAL_SAVE_SCENARIO_CONFIG_FILE_NAME @"localSavedScenario.json"

#define STR_NA @"N/A"
#define STR_FAIL @"Fail"
#define STR_UNKNOWN @"Unknown"
#define STR_SUCCESS @"Success"


// ftp
#define FTP_ADDR_NORMAL_MODE_MANUAL         @"0.0.0.0:1025/logdata/normal/manual/"
#define FTP_ADDR_ENGINEER_MODE_MANUAL       @"0.0.0.0:1025/logdata/engineer/manual/"
#define FTP_ADDR_ENGINEER_MODE_AUTOREPEAT   @"0.0.0.0:1025/logdata/engineer/AutoRepeat/"
#define FTP_ADDR_CONFIG_FILE                @"0.0.0.0:1025/"
#define FTP_USERNAME                        @"id"
#define FTP_PASSWORD                        @"pw"


#define UIColorFromRGB(rgbValue) [UIColor colorWithRed:((float)((rgbValue & 0xFF0000) >> 16))/255.0 green:((float)((rgbValue & 0xFF00) >> 8))/255.0 blue:((float)(rgbValue & 0xFF))/255.0 alpha:1.0]
#define RGBIntToDouble(rgbValue) ((double)rgbValue / 255.0)
#define UIColorFromIntRGB(r, g, b, a) [UIColor colorWithRed:RGBIntToDouble(r) green:RGBIntToDouble(g) blue:RGBIntToDouble(b) alpha:a]

#define MOBILE_DATA_CAP_DEFUALT 300

typedef double SKTimeIntervalMicroseconds;

@interface SKGlobalMethods : NSObject

+ (float)randomFloat:(float)minValue maxValue:(float)maxValue;

+ (NSString*)getTodaysDate;

#pragma mark - Calculations

#pragma mark - Formatting

+ (NSString *)formatDate:(NSDate*)date;

+ (NSString *)formatShorterDate:(NSDate*)date;

+ (NSString *)format3DecimalPlaces:(double)number;

+ (NSString *)format2DecimalPlaces:(double)number;

+ (NSString *)formatMilliseconds:(double)number;

+ (NSString *)format2Milliseconds:(double)number;

+ (NSString *)bytesToString:(double)value;

+ (NSString *)getTimeStamp;

#pragma mark - Miscellaneous

+ (NSString*)getCredentials:(NSString*)username password:(NSString*)password;

+ (BOOL)isActivated;

+ (NSString *)getLocalizedConnectionString:(ConnectionStatus)value;

+ (NSString *)getConnectionResultString:(ConnectionStatus)value;

+ (float)getCpuUsage;

+ (BOOL)addSkipBackupAttributeToItemAtURL:(NSURL*)URL;

+ (BOOL)deviceIsCurrentUnitId;
+ (void)printNSData:(NSData*)data;

+(NSString*)getCarrierName;
+(NSString*)getNetworkType;
+(NSString*)getNetworkTypeLocalized:(NSString*)theType;
+(NSString*)getCarrierMobileCountryCode;
+(NSString*)getCarrierNetworkCode;
+(NSString*)getCarrierIsoCountryCode;
+(NSString*)getSimOperatorCodeMCCAndMNC;
+(NSString*)getDeviceModel;
+(NSString*)getDevicePlatform;
+(NSString*)getNetworkOrGps;
+(NSString*)getNetworkTypeString;

+(NSString*)getNetworkType:(int)date networkType:(NSString*)networkType ForConnectionStatus:(ConnectionStatus)inConnectionStatus;
+(NSString*)getNetworkState:(int)date ForConnectionStatus:(ConnectionStatus)inConnectionStatus;
+(NSString*)getPhoneIdentity:(int)date;
+(NSString*)getSimOperator:(int)date;
+(NSString*)getCarrierInformation:(int)date;

+(void) setLongDateFormat:(NSString*)inFormat;
+(void) setShortDateFormat:(NSString*)inFormat;
+(void) setGraphDateFormat:(NSString*)inFormat;
+(NSString*) getGraphDateFormat;
+(NSString*) getGraphTimeFormat;

+(double) convertMbps1024BasedToMBps1000Based:(double)value1024Based;
+(double) convertBytesPerSecondToMbps1024Based:(double)bytesPerSecond;
+(NSString*) bitrateMbps1024BasedToString:(double)bitrateMbps1024Based;
+(NSString*) bitrateMbps1024BasedToStringWith2DecimalPlaces:(double)bitrateMbps1024Based;
+(double) convertLocalNumberStringToDouble:(NSString*)value;
+(NSString*) bitrateMbps1024BasedLocalNumberStringBasedToString:(NSString*)bitrateMbps1024BasedAsLocalString;
+(double)getBitrateMbps1024BasedDoubleForTransferTimeMicroseconds:(double)transferTimeMicroseconds transferBytes:(double)transferBytes;

+(NSString*) bitrateMbps1000BasedToString:(double)bitrateMbps1000Based;


+(NSString*) bitrateMbps1000BasedToStringWith2DecimalPlaces:(double)bitrateMbps1000Based;


+ (NSString *)makeCookieValueOfHeaderByCookies:(NSArray *)cookies;


+ (NSString *)makeCookieValueOfHeaderByURL:(NSURL *)requrl;


+(NSString *)configJsonFilePathWithFileName:(NSString *)fileName;


+(NSArray *)getServerListFromJson;


+(NSDictionary *)getScenarioFromJson;


+(NSArray *)arrFromJsonData:(NSData *)jsonData;


+(NSDictionary *)dicFromJsonData:(NSData *)jsonData;


+(BOOL)saveModifiedScenarioDic:(NSDictionary *)modifiedScenarioDic;


+(NSDictionary *)getLocalSavedScenarioFromJson;


+(NSDate *)dateFromyyyyMMdd_HHmmssString:(NSString *)dateString;


+(NSString *)yyyyMMdd_HHmmssStringFormDate:(NSDate *)date;


+(NSString *)getNetWorkTechName;

+(float)calculateHeightOfTextLabel:(NSString*)a_text withFont:(UIFont *)a_font withWidth:(float)a_width withlineBreakMode:(NSLineBreakMode)a_lineBreakMode;

+(void)saveMobileDataResetDay:(NSMutableDictionary *)dic;
+(NSMutableDictionary *)loadMobileDataResetDayInfo;
+(BOOL)isFirstRun;
+(void)saveIsFirstRun;
+(void)saveMobileDataCap:(unsigned int)mobileDataCap;
+(unsigned int)loadMobileDataCap;
+(void)saveMobileDataUsed:(unsigned long long)mobileDataUsed;
+(unsigned long long)loadMobileDataUsed;
+(BOOL)isMobileDataExceeded:(unsigned long long)estimatedTotalTrafficPerTest;

+(void)checkAndResetMobileDataUsage;
@end
