//
// SKAHttpTest.m
// SamKnows
//
// Copyright (c) 2011-2014 SamKnows Limited. All rights reserved.
//

#pragma mark - Interface

@interface SKAHttpTest ()

@end

#pragma mark - Implementation

@implementation SKAHttpTest

@synthesize outputResultsDictionary;

- (id)initWithTarget:(NSString*)_target
                port:(int)_port
                file:(NSString*)_file
        isDownstream:(BOOL)_isDownstream
       warmupMaxTime:(double)_warmupMaxTime
      warmupMaxBytes:(double)_warmupMaxBytes
     TransferMaxTimeMicroseconds:(SKTimeIntervalMicroseconds)_transferMaxTimeMicroseconds
    transferMaxBytes:(double)_transferMaxBytes
            nThreads:(int)_nThreads
            HttpTestDelegate:(id <SKHttpTestDelegate>)_delegate
{
  return [super initWithTarget:_target
                          port:_port
                          file:_file
                  isDownstream:_isDownstream
                 warmupMaxTime:(double)_warmupMaxTime
                warmupMaxBytes:(double)_warmupMaxBytes
               TransferMaxTimeMicroseconds:(double)_transferMaxTimeMicroseconds
              transferMaxBytes:(double)_transferMaxBytes
                      nThreads:_nThreads
                      HttpTestDelegate:_delegate
             runAsynchronously:NO];
}

- (void)storeOutputResults
{
    //    "type": "JHTTPPOSTMT",
    //    "bytes_sec": "167995",
    //    "datetime": "Fri Jan 25 15:35:36 GMT 2013",
    //    "number_of_threads": "3",
    //    "success": "true",
    //    "target": "n1-the1.samknows.com",
    //    "target_ipaddress": "46.17.56.234",
    //    "timestamp": "1359128136",
    //    "transfer_bytes": "1944064",
    //    "transfer_time": "11572113",
    //    "warmup_bytes": "114176",
    //    "warmup_time": "1496460"
    
    outputResultsDictionary = [[NSMutableDictionary alloc] init];
    
    if (self.isDownstream)
    {
        NSString *type = (self.nThreads == 1) ? DOWNSTREAMSINGLE : DOWNSTREAMMULTI;
        
        [outputResultsDictionary setObject:type
                          forKey:@"type"];
    }
    else
    {
        NSString *type = (self.nThreads == 1) ? UPSTREAMSINGLE : UPSTREAMMULTI;
        
        [outputResultsDictionary setObject:type
                          forKey:@"type"];
    }
    
    int bytePerSec = [self getBytesPerSecond];
    [outputResultsDictionary setObject:[NSString stringWithFormat:@"%d", bytePerSec]
                      forKey:@"bytes_sec"];
    
    [outputResultsDictionary setObject:[NSDate sGetDateAsIso8601String:[SKCore getToday]] forKey:@"datetime"];
    
    [outputResultsDictionary setObject:[NSString stringWithFormat:@"%d", self.nThreads]
                      forKey:@"number_of_threads"];
    
    [outputResultsDictionary setObject:self.testOK ? @"true" : @"false"
                      forKey:@"success"];
    
    [outputResultsDictionary setObject:self.target
                      forKey:@"target"];
    
    [outputResultsDictionary setObject:[SKIPHelper hostIPAddress:self.target]
                      forKey:@"target_ipaddress"];
    
    [outputResultsDictionary setObject:[NSString stringWithFormat:@"%d", (int)([[SKCore getToday] timeIntervalSince1970])]
                      forKey:@"timestamp"];
    
    [outputResultsDictionary setObject:[NSString stringWithFormat:@"%d", (int)self.testTransferBytes]
                      forKey:@"transfer_bytes"];
    
    [outputResultsDictionary setObject:[NSString stringWithFormat:@"%d", (int)(self.testTransferTimeMicroseconds)]
                      forKey:@"transfer_time"];
    
    [outputResultsDictionary setObject:[NSString stringWithFormat:@"%d", (int)self.testWarmupBytes]
                      forKey:@"warmup_bytes"];
    
    NSTimeInterval warmupTime = ((self.testWarmupEndTime - self.testWarmupStartTime) * 1000000);
    [outputResultsDictionary setObject:[NSString stringWithFormat:@"%d", (int)warmupTime] forKey:@"warmup_time"];
    

    
    if (self.isDownstream)
    {
        NSString *testResult = self.testOK ? STR_SUCCESS : STR_FAIL;
        [[TestResultDataCollector sharedInstance].GET_result addObject:testResult];
        [TestResultDataCollector sharedInstance].GET_thread = [NSString stringWithFormat:@"%d", self.nThreads];
        
        if([testResult isEqualToString:STR_SUCCESS])
        {
            [[TestResultDataCollector sharedInstance].GET_warmup_Bytes addObject:[NSNumber numberWithUnsignedInteger:self.testWarmupBytes]];
            [[TestResultDataCollector sharedInstance].GET_warmup_time addObject:[NSNumber numberWithDouble:warmupTime]];
            [[TestResultDataCollector sharedInstance].GET_Transfer_Time addObject:[NSNumber numberWithDouble:self.testTransferTimeMicroseconds]];
            [[TestResultDataCollector sharedInstance].GET_Byte_Total addObject:[NSNumber numberWithUnsignedInteger:self.testTransferBytes]];
            [[TestResultDataCollector sharedInstance].GET_Byte_sec addObject:[NSNumber numberWithInt:bytePerSec]];
        }
        else
        {
            [[TestResultDataCollector sharedInstance].GET_warmup_Bytes addObject:[NSNumber numberWithUnsignedInteger:TEST_RESULT_FAILED_VALUE_NSUInteger_TYPE]];
            [[TestResultDataCollector sharedInstance].GET_warmup_time addObject:[NSNumber numberWithDouble:TEST_RESULT_FAILED_VALUE_DOUBLE_TYPE]];
            [[TestResultDataCollector sharedInstance].GET_Transfer_Time addObject:[NSNumber numberWithDouble:TEST_RESULT_FAILED_VALUE_DOUBLE_TYPE]];
            [[TestResultDataCollector sharedInstance].GET_Byte_Total addObject:[NSNumber numberWithUnsignedInteger:TEST_RESULT_FAILED_VALUE_NSUInteger_TYPE]];
            [[TestResultDataCollector sharedInstance].GET_Byte_sec addObject:[NSNumber numberWithInt:TEST_RESULT_FAILED_VALUE_int_TYPE]];
        }
    }
    else
    {
        NSString *testResult = self.testOK ? STR_SUCCESS : STR_FAIL;
        [[TestResultDataCollector sharedInstance].POST_result addObject:testResult];
        [TestResultDataCollector sharedInstance].POST_thread = [NSString stringWithFormat:@"%d", self.nThreads];
        
        if([testResult isEqualToString:STR_SUCCESS])
        {
            [[TestResultDataCollector sharedInstance].POST_warmup_bytes addObject:[NSNumber numberWithUnsignedInteger:self.testWarmupBytes]];
            [[TestResultDataCollector sharedInstance].POST_warmup_time addObject:[NSNumber numberWithDouble:warmupTime]];
            [[TestResultDataCollector sharedInstance].POST_Transfer_Time addObject:[NSNumber numberWithDouble:self.testTransferTimeMicroseconds]];
            [[TestResultDataCollector sharedInstance].POST_Byte_Total addObject:[NSNumber numberWithUnsignedInteger:self.testTransferBytes]];
            [[TestResultDataCollector sharedInstance].POST_Byte_sec addObject:[NSNumber numberWithInt:bytePerSec]];
        }
        else
        {
            [[TestResultDataCollector sharedInstance].POST_warmup_bytes addObject:[NSNumber numberWithUnsignedInteger:TEST_RESULT_FAILED_VALUE_NSUInteger_TYPE]];
            [[TestResultDataCollector sharedInstance].POST_warmup_time addObject:[NSNumber numberWithDouble:TEST_RESULT_FAILED_VALUE_DOUBLE_TYPE]];
            [[TestResultDataCollector sharedInstance].POST_Transfer_Time addObject:[NSNumber numberWithDouble:TEST_RESULT_FAILED_VALUE_DOUBLE_TYPE]];
            [[TestResultDataCollector sharedInstance].POST_Byte_Total addObject:[NSNumber numberWithUnsignedInteger:TEST_RESULT_FAILED_VALUE_NSUInteger_TYPE]];
            [[TestResultDataCollector sharedInstance].POST_Byte_sec addObject:[NSNumber numberWithInt:TEST_RESULT_FAILED_VALUE_int_TYPE]];
        }
    }
    
}

@end
