//
//  ActivatingPopupViewController.h
//  SKCore
//
//  Created by jungeol.park on 2014. 8. 27..
//  Copyright (c) 2014 ACCVUER. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "SKClosestTargetTest.h"
#import "../3rdParty/GoldRaccoon/GRRequestsManager.h"

@protocol ActivatingPopupViewDelegate <NSObject>

@optional
-(void)dismissActivatingPopupView;

@end

@interface ActivatingPopupViewController : UIViewController
<SKClosestTargetDelegate, UIAlertViewDelegate, GRRequestsManagerDelegate>
{
    SKAAppDelegate *m_appDelegate;
    SKClosestTargetTest *m_closestTargetTest;
 
    NSInteger m_numberOfTargetServer;
    NSInteger m_numberOfTargetCompleted;
    
    NSMutableArray *m_progressPerTargetArr;
    
    BOOL m_isDownloadConfigFailed;
}

@property (strong, nonatomic) IBOutlet UIImageView *mainActivatingProgressBgImageView;
@property (strong, nonatomic) IBOutlet UIImageView *mainActivationProgressImageView;
@property (weak, nonatomic) IBOutlet UIActivityIndicatorView *downloadConfigIndicator;
@property (weak, nonatomic) IBOutlet UIActivityIndicatorView *closestFindingIndicator;
@property (weak, nonatomic) IBOutlet UILabel *completedStatusLabel;
@property (weak, nonatomic) IBOutlet UILabel *bestServerLabel;
@property (weak, nonatomic) IBOutlet UILabel *BestTimeLabel;

@property (strong, nonatomic) IBOutlet UIImageView *downloadConfigCheckImage;
@property (weak, nonatomic) IBOutlet UILabel *downloadConfigFailLabel;
@property (strong, nonatomic) IBOutlet UIImageView *closestFindingCheckImage;
@property (weak, nonatomic) IBOutlet UILabel *closestFindingFailLabel;


@property (assign, nonatomic) id <ActivatingPopupViewDelegate>delegate;

@property (nonatomic, strong) GRRequestsManager *requestsManager;
@end
