//
//  ActivatingPopupViewController.m
//  SKCore
//
//  Created by jungeol.park on 2014. 8. 27..
//  Copyright (c) 2014 ACCVUER. All rights reserved.
//

#import "ActivatingPopupViewController.h"
#import "SKAAppDelegate.h"
#import "NewTestScheduler.h"

#ifdef DEBUG
#define NUMBER_OF_DATAGRAMS 20 
#define NUMBER_OF_DATAGRAMS 10 
#else
#define NUMBER_OF_DATAGRAMS 10 
#endif
#define DOWNLOAD_CONFIG_COMPLITE_PROGRESS 20  
@interface ActivatingPopupViewController ()

@end

@implementation ActivatingPopupViewController


- (void)viewDidLoad
{
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    m_appDelegate = (SKAAppDelegate*)[UIApplication sharedApplication].delegate;
    
    [self initViews];
    
    [self startDownloadConfig];
}

-(void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - alert
-(void)showDownloadConfigErrorAlert
{
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:NSLocalizedString(@"information", nil)
                                                    message:NSLocalizedString(@"Download_Config_err_msg", nil)
                                                   delegate:self
                                          cancelButtonTitle:NSLocalizedString(@"MenuAlert_Cancel", nil)
                                          otherButtonTitles:NSLocalizedString(@"MenuAlert_Retry", nil), nil];
    [alert show];
}

-(void)showFindClosestTargetErrorAlert
{
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:NSLocalizedString(@"information", nil)
                                                    message:NSLocalizedString(@"Closest_Server_Find_err_msg", nil)
                                                   delegate:self
                                          cancelButtonTitle:NSLocalizedString(@"MenuAlert_Cancel", nil)
                                          otherButtonTitles:NSLocalizedString(@"MenuAlert_Retry", nil), nil];
    [alert show];
}

-(void)alertView:(UIAlertView *)alertView didDismissWithButtonIndex:(NSInteger)buttonIndex
{
    if (buttonIndex == alertView.cancelButtonIndex)
    {
        
        exit(0);
    }
    else
    {
        // retry activating
        self.requestsManager = nil;
        [self initViews];
        [self performSelector:@selector(startDownloadConfig) withObject:nil afterDelay:1];
//        [self startDownloadConfig];
    }
}

#pragma mark - Download Config
-(void)startDownloadConfig
{
    [self.downloadConfigIndicator startAnimating];
    m_isDownloadConfigFailed = NO;
    
    NSString *localServerListSavePath = [SKGlobalMethods configJsonFilePathWithFileName:SERVER_LIST_CONFIG_FILE_NAME];
    if ([[NSFileManager defaultManager] fileExistsAtPath:localServerListSavePath])
    {
        [[NSFileManager defaultManager] removeItemAtPath:localServerListSavePath error:NULL];
        NSLog(@"Server list file exists. Existing File is Deleted.");
    }
    NSString *localScenarioSavePath = [SKGlobalMethods configJsonFilePathWithFileName:SCENARIO_CONFIG_FILE_NAME];
    if ([[NSFileManager defaultManager] fileExistsAtPath:localScenarioSavePath])
    {
        [[NSFileManager defaultManager] removeItemAtPath:localScenarioSavePath error:NULL];
        NSLog(@"Scenario file exists. Existing File is Deleted.");
    }
    
    
    [self _setupManager];
    [self.requestsManager addRequestForDownloadFileAtRemotePath:SERVER_LIST_CONFIG_FILE_NAME toLocalPath:localServerListSavePath];
    [self.requestsManager addRequestForDownloadFileAtRemotePath:SCENARIO_CONFIG_FILE_NAME toLocalPath:localScenarioSavePath];
    [self.requestsManager startProcessingRequests];
}

// Private Methods
- (void)_setupManager
{
    if(self.requestsManager == nil)
    {
        self.requestsManager = [[GRRequestsManager alloc] initWithHostname:FTP_ADDR_CONFIG_FILE
                                                                      user:FTP_USERNAME
                                                                  password:FTP_PASSWORD];
        self.requestsManager.delegate = self;
    }
}
#pragma mark - GRRequestsManagerDelegate

- (void)requestsManager:(id<GRRequestsManagerProtocol>)requestsManager didScheduleRequest:(id<GRRequestProtocol>)request
{
    // do nothing
}

- (void)requestsManager:(id<GRRequestsManagerProtocol>)requestsManager didCompleteDownloadRequest:(id<GRDataExchangeRequestProtocol>)request
{
    // do nothing
}

- (void)requestsManager:(id<GRRequestsManagerProtocol>)requestsManager didFailWritingFileAtPath:(NSString *)path forRequest:(id<GRDataExchangeRequestProtocol>)request error:(NSError *)error
{
    [requestsManager stopAndCancelAllRequests];
    m_isDownloadConfigFailed = YES;
    [self downloadConfigrationFailed];
}

- (void)requestsManager:(id<GRRequestsManagerProtocol>)requestsManager didFailRequest:(id<GRRequestProtocol>)request withError:(NSError *)error
{
    [requestsManager stopAndCancelAllRequests];
    m_isDownloadConfigFailed = YES;
    [self downloadConfigrationFailed];
}

- (void)requestsManagerDidCompleteQueue:(id<GRRequestsManagerProtocol>)requestsManager
{
    self.requestsManager = nil;
    
    if(m_isDownloadConfigFailed == NO)
        [self downloadConfigrationComplete];
}

#pragma mark - start closest target test
-(void)startFindingClosestTarget
{
    //conif EEEE.
#ifdef USE_NEW_TEST_SCHEDULER
    m_appDelegate.testSchedule_new = [[NewTestScheduler alloc] init];
    if ([m_appDelegate.testSchedule_new startLoadConfigFromJsonFiles] == NO)
    {
        // error
        [self findClosestTargetFailed];
    }
    
    NSMutableDictionary *closestTestInfo = m_appDelegate.testSchedule_new.m_closestTargetTestInfo;
    
#else
    NSArray *testsAndTimes = [[m_appDelegate amdGetSchedule] getTestsAndTimes];
    NSArray *test = [testsAndTimes objectAtIndex:0];
    NSDictionary *closestTestInfo = [test objectAtIndex:0];
#endif
    if(closestTestInfo != nil)
    {
        SKTestConfig *closestTestConfig = [[SKTestConfig alloc] initWithDictionary:closestTestInfo ];
        
        if(closestTestConfig != nil)
        {
            NSArray *targets = [closestTestConfig getTargets];
            
            if(m_closestTargetTest == nil)
            {
                m_closestTargetTest = [[SKAClosestTargetTest alloc] initWithTargets:targets ClosestTargetDelegate:self NumDatagrams:NUMBER_OF_DATAGRAMS];
            }
            else
            {
                [m_closestTargetTest setTargets:targets];
            }
            
            [m_closestTargetTest setTestIndex:0];
            [m_closestTargetTest setNetworkType:[closestTestConfig getNetworkType]];
            [m_closestTargetTest setDisplayName:[closestTestConfig displayName]];
            
            if([m_closestTargetTest isReady])
            {
                m_numberOfTargetServer = targets.count;
                m_numberOfTargetCompleted= 0;
                [self.closestFindingIndicator startAnimating];
                [self.completedStatusLabel setText:[NSString stringWithFormat:@"0 of %d", (int)m_numberOfTargetServer]];
                
                [m_closestTargetTest startTest];
                
                // progress EEE array
                m_progressPerTargetArr = [[NSMutableArray alloc] init];
                for (int i=0; i<m_numberOfTargetServer; i++)
                {
                    [m_progressPerTargetArr addObject:[NSNumber numberWithFloat:0.0f]];
                }
            }
            else
            {
                // error
                [self findClosestTargetFailed];
            }
        }
    }
}


#pragma mark - UI controll
-(void) initViews
{
    [self.downloadConfigIndicator stopAnimating];
    [self.downloadConfigCheckImage setHidden:YES];
    [self.downloadConfigFailLabel setHidden:YES];
    [self.closestFindingIndicator stopAnimating];
    [self.closestFindingCheckImage setHidden:YES];
    [self.closestFindingFailLabel setHidden:YES];
    
    [self setMainActivatingProgressBar:0.0f];
    
    [self.completedStatusLabel setText:@"-"];
    [self.bestServerLabel setText:@"-"];
    [self.BestTimeLabel setText:@"-"];
}

-(void)downloadConfigrationComplete
{
#ifndef USE_NEW_TEST_SCHEDULER
    [m_appDelegate populateSchedule];
#endif
    
    [self setMainActivatingProgressBar: DOWNLOAD_CONFIG_COMPLITE_PROGRESS / 100.0f];
    
    [self.downloadConfigIndicator stopAnimating];
    [self.downloadConfigCheckImage setHidden:NO];
    
    [self startFindingClosestTarget];
}

-(void)downloadConfigrationFailed
{
    [self.downloadConfigIndicator stopAnimating];
    [self.downloadConfigFailLabel setHidden:NO];
    
    [self showDownloadConfigErrorAlert];
}

-(void)findClosestTargetFailed
{
    [self.closestFindingIndicator stopAnimating];
    [self.closestFindingFailLabel setHidden:NO];
    
    [self showFindClosestTargetErrorAlert];
}

-(void)dismissPopupView
{
    if ([self.delegate respondsToSelector:@selector(dismissActivatingPopupView)])
        [self.delegate dismissActivatingPopupView];
}

-(void)setMainActivatingProgressBar:(float)progress
{
    CGRect pFrame = self.mainActivatingProgressBgImageView.frame;
    CGRect pRect = CGRectMake(pFrame.origin.x, pFrame.origin.y, pFrame.size.width*progress, pFrame.size.height);
    self.mainActivationProgressImageView.frame = pRect;
}

#pragma mark - SKClosestTargetDelegate

- (void)ctdDidCompleteClosestTargetTest:(NSString*)targetIP latency:(double)latency
{
    [SKAAppDelegate setClosestTarget:targetIP];
//    [SKAAppDelegate setIsActivated:YES];
    
    [self setMainActivatingProgressBar:1.0f];
    
    [self.closestFindingIndicator stopAnimating];
    [self.closestFindingCheckImage setHidden:NO];
#ifdef USE_NEW_TEST_SCHEDULER
    NSString *targetName = [m_appDelegate.testSchedule_new getClosestTargetName:targetIP];
    [m_appDelegate.testSchedule_new poplateAllTestsInfoWithBestServer:targetName];
#else
    NSString *targetName = [m_appDelegate.schedule getClosestTargetName:targetIP];
#endif
    [self.bestServerLabel setText:targetName];
    [self.BestTimeLabel setText:[NSString stringWithFormat:@"%f", latency]];
    
    
    if(m_closestTargetTest != nil)
    {
        [m_closestTargetTest stopTest];
        m_closestTargetTest = nil;
    }
    
    
    [self performSelector:@selector(dismissPopupView) withObject:nil afterDelay:2];

}

- (void)ctdTestDidFail
{
    [self findClosestTargetFailed];
}

- (void)ctdDidSendPacket:(NSUInteger)bytes
{
    [m_appDelegate amdDoUpdateDataUsage:(int)bytes];
}

- (void)ctdUpdateProgress:(float)progress threadId:(NSUInteger)threadId
{
    @synchronized(self)
    {
        if(progress == 100.0f)
        {
            m_numberOfTargetCompleted++;
            [self.completedStatusLabel setText:[NSString stringWithFormat:@"%d of %d", (int)m_numberOfTargetCompleted, (int)m_numberOfTargetServer]];
        }
        
        [m_progressPerTargetArr replaceObjectAtIndex:threadId withObject:[NSNumber numberWithFloat:progress]];
        
        float sumOfEachThread = 0;
        for ( NSNumber *temp in m_progressPerTargetArr) {
            sumOfEachThread += [temp floatValue];
        }
        float avgProgress = sumOfEachThread / ((float)m_progressPerTargetArr.count);
        
        float closetTestProgress = avgProgress * (float)(1.0f - (DOWNLOAD_CONFIG_COMPLITE_PROGRESS/100.f));
        float totalProgress = DOWNLOAD_CONFIG_COMPLITE_PROGRESS + closetTestProgress;
        
        [self setMainActivatingProgressBar:totalProgress / 100.0f];
    }
}

@end
