//
//  DLULSettingPopupViewController.h
//  SKCore
//
//  Created by jungeol.park on 2014. 9. 30..
//  Copyright (c) 2014 ACCVUER. All rights reserved.
//

#import <UIKit/UIKit.h>

@protocol DLULSettingPopupViewDelegate <NSObject>

@required
-(void)dismissDLULSettingPopupView;
-(void)dismissDLULSettingPopupViewWithModifiedDic:(NSDictionary *)dic withIsDownload:(BOOL)isDownload;
@end

@interface DLULSettingPopupViewController : UIViewController <UITextFieldDelegate>
{
    UITapGestureRecognizer *tgr;
    int m_fileSize_saved, m_testTime_saved, m_count_saved, m_numberOfSession_saved;
    int m_fileSize_modified, m_testTime_modified, m_count_modified, m_numberOfSession_modified;
}
@property (weak, nonatomic) IBOutlet UILabel *titleLabel;
@property (strong, nonatomic) IBOutlet UITextField *fileSizeTextField;
@property (strong, nonatomic) IBOutlet UITextField *timeTextField;
@property (strong, nonatomic) IBOutlet UITextField *countTextField;
@property (strong, nonatomic) IBOutlet UITextField *sessionTextField;

@property (nonatomic) BOOL isDownLoad;
@property (nonatomic, strong) NSMutableDictionary *configInfoDic; //download or upload

@property (assign, nonatomic) id <DLULSettingPopupViewDelegate>delegate;


- (IBAction)okButtonClicked:(id)sender;
- (IBAction)cancelButtonClicked:(id)sender;

@end
