//
//  DLULSettingPopupViewController.m
//  SKCore
//
//  Created by jungeol.park on 2014. 9. 30..
//  Copyright (c) 2014 ACCVUER. All rights reserved.
//

#import "DLULSettingPopupViewController.h"

#define TEXTFIELD_VALUE_NOT_CHANGED -1

@interface DLULSettingPopupViewController ()

@end

@implementation DLULSettingPopupViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    m_fileSize_modified = TEXTFIELD_VALUE_NOT_CHANGED;
    m_testTime_modified = TEXTFIELD_VALUE_NOT_CHANGED;
    m_count_modified = TEXTFIELD_VALUE_NOT_CHANGED;
    m_numberOfSession_modified = TEXTFIELD_VALUE_NOT_CHANGED;
    
    
/////// self.configInfoDic EE
//  @"20", @"Filesize",
//  @"2", @"Count",
//  @"3", @"Session",
//  @"20000000", @"Time",
///////
    
    m_fileSize_saved = [[self.configInfoDic objectForKey:@"Filesize"] intValue];
    m_testTime_saved = [self microSecToSec:[[self.configInfoDic objectForKey:@"Time"] intValue]];
    m_count_saved = [[self.configInfoDic objectForKey:@"Count"] intValue];
    m_numberOfSession_saved = [[self.configInfoDic objectForKey:@"Session"] intValue];
    
    
    
    self.fileSizeTextField.text = [NSString stringWithFormat:@"%d MB", m_fileSize_saved];
    self.timeTextField.text = [NSString stringWithFormat:@"%d sec", m_testTime_saved];
    self.countTextField.text = [NSString stringWithFormat:@"%d", m_count_saved];
    self.sessionTextField.text = [NSString stringWithFormat:@"%d", m_numberOfSession_saved];
    
    if (self.isDownLoad)
    {
        self.titleLabel.text = NSLocalizedString(@"Download test setting", nil);
        self.sessionTextField.placeholder = @"1 ~ 20";
    }
    else
    {
        self.titleLabel.text = NSLocalizedString(@"Upload test setting", nil);
        self.sessionTextField.placeholder = @"1 ~ 4";
    }
    
    self.fileSizeTextField.placeholder = @"3 ~ 30";
    self.timeTextField.placeholder = @"5 ~ 30";
    self.countTextField.placeholder = @"1 ~ 9999";
    
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

#pragma mark - text field
-(void)textFieldDidBeginEditing:(UITextField *)textField
{
    textField.text = @"";
    
    if (tgr == nil)
    {
        tgr = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(tapDetected:)];
        tgr.numberOfTapsRequired = 1;
        
        if(self.view.superview != nil)
            [self.view.superview addGestureRecognizer:tgr];
        else
            [self.view addGestureRecognizer:tgr];
    }
}

-(BOOL)textFieldShouldEndEditing:(UITextField *)textField
{
    NSString *text = textField.text;
    
    if ([textField isEqual:self.fileSizeTextField])
    {
        if (text.length == 0)
        {
            textField.text = [NSString stringWithFormat:@"%d MB", m_fileSize_saved];
            m_fileSize_modified = TEXTFIELD_VALUE_NOT_CHANGED;
        }
        else
        {
            int v = [text intValue];
            if(v < 3 || v > 30)
            {
                [self showInvalidInputAlretWithMsg:@"Please enter a valid value: 3 ~ 30"];
                return NO;
            }
            else
            {
                m_fileSize_modified = v;
                textField.text = [NSString stringWithFormat:@"%d MB", v];
            }
        }
        
    }
    else if ([textField isEqual:self.timeTextField])
    {
        if (text.length == 0)
        {
            textField.text = [NSString stringWithFormat:@"%d sec", m_testTime_saved];
            m_testTime_modified = TEXTFIELD_VALUE_NOT_CHANGED;
        }
        else
        {
            int v = [text intValue];
            if(v < 5 || v > 30)
            {
                [self showInvalidInputAlretWithMsg:@"Please enter a valid value: 5 ~ 30"];
                return NO;
            }
            else
            {
                m_testTime_modified = v;
                textField.text = [NSString stringWithFormat:@"%d sec", v];
            }
        }
    }
    else if ([textField isEqual:self.countTextField])
    {
        if (text.length == 0)
        {
            textField.text = [NSString stringWithFormat:@"%d", m_count_saved];
            m_count_modified = TEXTFIELD_VALUE_NOT_CHANGED;
        }
        else
        {
            int v = [text intValue];
            if(v < 1 || v > 9999)
            {
                [self showInvalidInputAlretWithMsg:@"Please enter a valid value: 1 ~ 9999"];
                return NO;
            }
            else
                m_count_modified = v;
        }
        
    }
    else// if ([textField isEqual:self.sessionTextField])
    {
        if (text.length == 0)
        {
            textField.text = [NSString stringWithFormat:@"%d", m_numberOfSession_saved];
            m_numberOfSession_modified = TEXTFIELD_VALUE_NOT_CHANGED;
        }
        else
        {
            if(self.isDownLoad)
            {
                int v = [text intValue];
                if(v < 1 || v > 20)
                {
                    [self showInvalidInputAlretWithMsg:@"Please enter a valid value: 1 ~ 20"];
                    return NO;
                }
                else
                    m_numberOfSession_modified = v;
            }
            else
            {
                int v = [text intValue];
                if(v < 1 || v > 4)
                {
                    [self showInvalidInputAlretWithMsg:@"Please enter a valid value: 1 ~ 4"];
                    return NO;
                }
                else
                    m_numberOfSession_modified = v;
            }
        }
    }
    
    return YES;
}

-(void)textFieldDidEndEditing:(UITextField *)textField
{
    if(tgr != nil)
    {
        if(self.view.superview != nil)
            [self.view.superview removeGestureRecognizer:tgr];
        else
            [self.view removeGestureRecognizer:tgr];
        
        tgr = nil;
    }
}

-(void)tapDetected:(UIGestureRecognizer *)sender
{
    [self.fileSizeTextField resignFirstResponder];
    [self.timeTextField resignFirstResponder];
    [self.countTextField resignFirstResponder];
    [self.sessionTextField resignFirstResponder];
}

- (IBAction)okButtonClicked:(id)sender
{
    
    [self tapDetected:nil];
    
    if (m_fileSize_modified !=  TEXTFIELD_VALUE_NOT_CHANGED
        || m_testTime_modified != TEXTFIELD_VALUE_NOT_CHANGED
        || m_count_modified != TEXTFIELD_VALUE_NOT_CHANGED
        || m_numberOfSession_modified != TEXTFIELD_VALUE_NOT_CHANGED)
    {
        int fileSize = (m_fileSize_modified == TEXTFIELD_VALUE_NOT_CHANGED) ? m_fileSize_saved : m_fileSize_modified;
        int testTime = (m_testTime_modified == TEXTFIELD_VALUE_NOT_CHANGED) ? m_testTime_saved : m_testTime_modified;
        int count = (m_count_modified == TEXTFIELD_VALUE_NOT_CHANGED) ? m_count_saved : m_count_modified;
        int session = (m_numberOfSession_modified == TEXTFIELD_VALUE_NOT_CHANGED) ? m_numberOfSession_saved : m_numberOfSession_modified;
        
        NSDictionary *configDic = [[NSDictionary alloc] initWithObjectsAndKeys:
                              [NSString stringWithFormat:@"%d", fileSize], @"Filesize",
                              [NSString stringWithFormat:@"%d", count], @"Count",
                              [NSString stringWithFormat:@"%d", session], @"Session",
                              [NSString stringWithFormat:@"%d", [self secToMicrosec:testTime]], @"Time",
                              nil];
        
        if ([self.delegate respondsToSelector:@selector(dismissDLULSettingPopupViewWithModifiedDic:withIsDownload:)])
        {
            [self.delegate dismissDLULSettingPopupViewWithModifiedDic:configDic withIsDownload:self.isDownLoad];
        }
    }
    else
    {
        if ([self.delegate respondsToSelector:@selector(dismissDLULSettingPopupView)])
            [self.delegate dismissDLULSettingPopupView];
    }
}

- (IBAction)cancelButtonClicked:(id)sender
{
    
    [self tapDetected:nil];
    
    if ([self.delegate respondsToSelector:@selector(dismissDLULSettingPopupView)])
        [self.delegate dismissDLULSettingPopupView];
}

-(void)showInvalidInputAlretWithMsg:(NSString *)alretMsg
{
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:NSLocalizedString(@"information", nil)
                                                    message:alretMsg
                                                   delegate:nil
                                          cancelButtonTitle:NSLocalizedString(@"MenuAlert_OK", nil)
                                          otherButtonTitles:nil];
    [alert show];
}

#pragma mark - converter
-(int)secToMicrosec:(int)sec
{
    return sec * 1000000;
}

-(int)microSecToSec:(int)microSec
{
    return  microSec / 1000000;
}


@end
