//
//  SettingView.h
//  SKCore
//
//  Created by jungeol.park on 2014. 10. 1..
//  Copyright (c) 2014 ACCVUER. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "DLULSettingPopupViewController.h"


/**
 @class SettingView
 @discussion engineer mode
 */
@interface EngineerModeSettingView : UIView <DLULSettingPopupViewDelegate, UITextFieldDelegate>
{
    UITapGestureRecognizer *tgr;
    int m_idleTime_saved, m_repeatCount_saved;
    BOOL m_isAutoRepeat_saved;
    NSMutableDictionary *m_scenarioDic;
    NSMutableDictionary *m_commonInfoDic;
    NSMutableDictionary *m_downloadInfoDic;
    NSMutableDictionary *m_uploadInfoDic;
    NSMutableDictionary *m_latencyInfoDic;
    
    BOOL m_isAutoRepeatModified;
}

@property (strong, nonatomic) IBOutlet UITextField *idleTimeTextField;
@property (strong, nonatomic) IBOutlet UITextField *repeatCountTextField;

@property (strong, nonatomic) IBOutlet UIImageView *autoRepeatUncheckedBoxImage;
@property (strong, nonatomic) IBOutlet UIImageView *autoRepeatCheckedBoxImage;

- (IBAction)checkBoxClicked:(id)sender;
- (IBAction)callDownloadSettingPopup:(id)sender;
- (IBAction)callUploadSettingPopup:(id)sender;

-(void)initViews;

@end
