//
//  FTPLogger.m
//  SKCore
//
//  Created by KSW on 2014. 12. 3..
//  Copyright (c) 2014 SamKnows. All rights reserved.
//

#import "FTPLogger.h"

@implementation FTPLogger


+ (void)writeLogToFile:(NSString *)str
{
#ifdef FTP_LOGGER
    
    NSFileManager *fileM = [NSFileManager defaultManager];
    
    if([fileM fileExistsAtPath:[FTPLogger getDocumentDirPathWithFileName:LOG_FILE_NAME]] == NO)
    {
        [fileM createFileAtPath:[FTPLogger getDocumentDirPathWithFileName:LOG_FILE_NAME] contents:nil attributes:nil];
    }
    
    
    NSFileHandle *fileHandle = [NSFileHandle fileHandleForUpdatingAtPath:[FTPLogger getDocumentDirPathWithFileName:LOG_FILE_NAME]];
    
    NSData *writeData = [str dataUsingEncoding:NSUTF8StringEncoding];
    
    [fileHandle seekToEndOfFile];
    [fileHandle writeData:writeData];
    
    [fileHandle closeFile];
#endif
}


+ (NSString *)getDocumentDirPathWithFileName:(NSString *)a_strName
{
    NSString *docsDir, *fileName;
    NSArray *dirPaths;
    
    dirPaths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,
                                                   NSUserDomainMask, YES);
    
    docsDir = [dirPaths objectAtIndex:0];
    fileName = a_strName;
    
    return [docsDir stringByAppendingPathComponent:fileName];
}

@end
