//
//  FirstMainMenuViewController.m
//  SKCore
//
//  Created by jungeol.park on 2014. 8. 27..
//  Copyright (c) 2014 ACCVUER. All rights reserved.
//

#import "FirstMainMenuViewController.h"
#import "UIViewController+MJPopupViewController.h"
#import "MainPagingScrollViewController.h"

@interface FirstMainMenuViewController ()

@end

@implementation FirstMainMenuViewController

//@synthesize activatingPopupViewController;

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    // app version
    NSString *appVersion = [[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleShortVersionString"];
    NSString *versionStr = [NSString stringWithFormat:NSLocalizedString(@"Current Version: %@", nil), appVersion];
    [self.appVersionLabel setText:versionStr];
    
    
    [self callActivatingPopup:nil];
}

-(void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender
{
    MainPagingScrollViewController *mainPSVC = segue.destinationViewController;
    [mainPSVC setModalTransitionStyle:UIModalTransitionStyleFlipHorizontal];
    [SKAAppDelegate getAppDelegate].mainPagingScrollVC = mainPSVC;
    
    if ([segue.identifier isEqualToString:@"MeasurementSegue"])
    {
        mainPSVC.m_initalMenuTitle = MENU_TITLE_MEASUREMENT;
    }
    else if ([segue.identifier isEqualToString:@"SettingSegue"])
    {
        mainPSVC.m_initalMenuTitle = MENU_TITLE_SETTING;
    }
    else if ([segue.identifier isEqualToString:@"HistorySegue"])
    {
        mainPSVC.m_initalMenuTitle = MENU_TITLE_HISTORY;
    }
}

- (IBAction)callActivatingPopup:(id)sender
{
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Main" bundle:[NSBundle mainBundle]];
    ActivatingPopupViewController *vc = [storyboard instantiateViewControllerWithIdentifier:@"ActivatingPopupViewController"];

    vc.delegate = self;
    [self presentPopupViewController:vc animationType:MJPopupViewAnimationSlideBottomBottom isEnableBgTouch:NO];
}

- (IBAction)measurementClicked:(id)sender
{
    
}

#pragma makr - ActivatingPopupViewDelegate
- (void)dismissActivatingPopupView
{
    [self dismissPopupViewControllerWithanimationType:MJPopupViewAnimationSlideBottomBottom];
}
@end
