//
//  HTTPRequest.h
//  SKCore
//
//  Created by jungeol.park on 2014. 9. 25..
//  Copyright (c) 2014 ACCVUER. All rights reserved.
//

#import <Foundation/Foundation.h>
//#import "SKAAppDelegate.h"


typedef NS_ENUM(NSInteger, TransferWaitingQueueErrorType) {
    TransferWaitingQueueErrorType_None,
    TransferWaitingQueueErrorType_ConnectionError,
    TransferWaitingQueueErrorType_NoResponseDataError,
    TransferWaitingQueueErrorType_JSONParsingError,
    TransferWaitingQueueErrorType_StatusCodeError
};


@protocol HTTPRequestDelegate <NSObject>

@optional
-(void)didReceiveTransferWaitingQueueResponsWithPosition:(NSInteger)position withError:(TransferWaitingQueueErrorType)errorType;
@end


@interface HTTPRequest : NSObject
{
    NSString *m_serverAdd;
    NSString *m_port;
    BOOL m_needStopRequestWaitingQueue;
}

@property (nonatomic, assign) id<HTTPRequestDelegate> delgate;

-(void)requestTransferWaitingQueue;
-(void)stopRequestTransferWaitingQueue;

-(void)requestEndTransferSession;
@end
