//
//  HistoryDataDetailPopupViewController.m
//  SKCore
//
//  Created by jungeol.park on 2014. 9. 30..
//  Copyright (c) 2014 ACCVUER. All rights reserved.
//

#import "HistoryDataDetailPopupViewController.h"

@interface HistoryDataDetailPopupViewController ()

@end

@implementation HistoryDataDetailPopupViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self initLables];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

/*
 historyDataDic
{
    accuracy = "65.000000";
    "avg_dl_throughput" = "35.381942";
    "avg_ul_throughput" = "45.138713";
    endtime = "20141106_140232";
    id = 1;
    latency = "4.803649";
    latitude = "37.493890";
    longitude = "126.818080";
    "max_dl_throughput" = "52.268692";
    "max_ul_throughput" = "45.989258";
    "network_type" = WIFI;
    "packet_loss_ratio" = "0.000000";
    starttime = "20141106_140128";
}
*/

-(void)initLables
{
    int index = [[self.m_historyCellDataDic objectForKey:@"id"] intValue];
    self.headLineLabel.text = [NSString stringWithFormat:NSLocalizedString(@"No.%d Collected Data", nil), index];
    
    self.startTimeLabel.text = [self.m_historyCellDataDic objectForKey:@"starttime"];
    self.endTimeLabel.text = [self.m_historyCellDataDic objectForKey:@"endtime"];
    self.networkLabel.text = [self.m_historyCellDataDic objectForKey:@"network_type"];
    self.cellIDLabel.text = STR_NA;
    self.rssiLabel.text = [NSString stringWithFormat:@"%@ dBm", STR_NA];
    
    NSString *latencyStr = [NSString stringWithFormat:@"%@", [self.m_historyCellDataDic objectForKey:@"latency"]];
    if ([latencyStr isEqualToString:STR_FAIL] || [latencyStr isEqualToString:STR_UNKNOWN])
    {
        self.latencyLabel.text = NSLocalizedString(@"Fail", nil);
    }
    else
    {
        NSString *latency = [NSString stringWithFormat:@"%.2f ms", [latencyStr doubleValue]];
        self.latencyLabel.text = latency;
    }
  
    NSString *packetLossStr = [NSString stringWithFormat:@"%@", [self.m_historyCellDataDic objectForKey:@"packet_loss_ratio"]];
    if ([packetLossStr isEqualToString:STR_FAIL] || [packetLossStr isEqualToString:STR_UNKNOWN])
    {
        self.packetLossLabel.text = NSLocalizedString(@"Fail", nil);
    }
    else
    {
        NSString *packetLoss = [NSString stringWithFormat:@"%.1f %%", [packetLossStr doubleValue]];
        self.packetLossLabel.text = packetLoss;
    }
    
    // avg download throughput
    NSString *avgDLStr = [NSString stringWithFormat:@"%@", [self.m_historyCellDataDic objectForKey:@"avg_dl_throughput"]];
    if ([avgDLStr isEqualToString:STR_FAIL] || [avgDLStr isEqualToString:STR_UNKNOWN])
    {
        self.downloadLabel.text = NSLocalizedString(@"Fail", nil);
    }
    else
    {
        double avgDownload_1000Based = [avgDLStr doubleValue];
        NSString *avgDownload = [SKGlobalMethods bitrateMbps1000BasedToStringWith2DecimalPlaces:avgDownload_1000Based];
        self.downloadLabel.text = [NSString stringWithFormat:@"%@ Mbps", avgDownload];
    }
    
    // avg upload throughput
    NSString *avgULStr = [NSString stringWithFormat:@"%@", [self.m_historyCellDataDic objectForKey:@"avg_ul_throughput"]];
    if ([avgULStr isEqualToString:STR_FAIL] || [avgULStr isEqualToString:STR_UNKNOWN])
    {
        self.uploadLabel.text = NSLocalizedString(@"Fail", nil);
    }
    else
    {
        double avgUpload_1000Based = [avgULStr doubleValue];
        NSString *avgUpload = [SKGlobalMethods bitrateMbps1000BasedToStringWith2DecimalPlaces:avgUpload_1000Based];
        self.uploadLabel.text = [NSString stringWithFormat:@"%@ Mbps", avgUpload];
    }
    
    // GPS
    double latitude = [[self.m_historyCellDataDic objectForKey:@"latitude"] doubleValue];
    NSString *lati = (latitude == TEST_RESULT_UNKNOW_VALUE_DOUBLE_TYPE) ? STR_UNKNOWN : [NSString stringWithFormat:@"%f", latitude];
    self.gpsLatiLabel.text = lati;
    
    double longitude = [[self.m_historyCellDataDic objectForKey:@"longitude"] doubleValue];
    NSString *longi = (longitude == TEST_RESULT_UNKNOW_VALUE_DOUBLE_TYPE) ? STR_UNKNOWN : [NSString stringWithFormat:@"%f", longitude];
    self.gpsLongLabel.text = longi;
    
    double accuracy = [[self.m_historyCellDataDic objectForKey:@"accuracy"] doubleValue];
    NSString *accu = (accuracy == TEST_RESULT_UNKNOW_VALUE_DOUBLE_TYPE) ? STR_UNKNOWN : [NSString stringWithFormat:@"%.1f m", accuracy];
    self.gpsAccuracyLabel.text = accu;
}

- (IBAction)closeButtonClicked:(id)sender
{
    if ([self.delegate respondsToSelector:@selector(dismissHistoryDataDetailPopupView)])
    {
        [self.delegate dismissHistoryDataDetailPopupView];
    }
}

@end
