//
//  ContenctsManagementViewController.m
//  SKCore
//
//  Created by jungeol.park on 2014. 9. 3..
//  Copyright (c) 2014 ACCVUER. All rights reserved.
//

#import "MainPagingScrollViewController.h"
#import "MenuTableViewCell.h"

@interface MainPagingScrollViewController ()

@end

@implementation MainPagingScrollViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    
      
    self.m_horizontalMenuTableView.bounces = NO;
    [self rotateMenuTableView];
    

    CGFloat width = self.view.frame.size.width;
    CGFloat height = self.view.frame.size.height - 64;
    
    m_menuTitleArr = [[NSArray alloc] initWithObjects:MENU_TITLE_MEASUREMENT, MENU_TITLE_HISTORY, MENU_TITLE_SETTING, nil];
    
    //add view to paging scroll view
    self.m_runTestView.frame = CGRectMake(0, 0, width, height);
    self.m_historyView.frame = CGRectMake(width, 0, width, height);
    
    [self.m_contentsPagingScrollView addSubview:self.m_runTestView];
    [self.m_contentsPagingScrollView addSubview:self.m_historyView];
    
    [self.m_runTestView initViews];
    [self.m_historyView initViews];
    
    
    self.m_normalModeSettingView.frame = CGRectMake(width*2, 0, width, height);
    [self.m_contentsPagingScrollView addSubview:self.m_normalModeSettingView];
    [self.m_normalModeSettingView initViews];
    
    self.m_contentsPagingScrollView.contentSize = CGSizeMake(width * m_menuTitleArr.count, height);
    
    NSInteger initalMenuIndex = 0;
    if(self.m_initalMenuTitle != nil && self.m_initalMenuTitle.length > 0)
        initalMenuIndex = [m_menuTitleArr indexOfObject:self.m_initalMenuTitle];
    
    NSIndexPath *indexPath_firstCell = [NSIndexPath indexPathForRow:initalMenuIndex inSection:0];
    [self.m_horizontalMenuTableView selectRowAtIndexPath:indexPath_firstCell animated:NO scrollPosition:UITableViewScrollPositionTop];
    
    CGPoint offset = CGPointMake(self.m_contentsPagingScrollView.frame.size.width * initalMenuIndex, 0);
    [self.m_contentsPagingScrollView setContentOffset:offset];
}

-(void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    [[NSNotificationCenter defaultCenter] addObserver:self.m_runTestView selector:@selector(udpTestFailedSkipTests:) name:kSKAAutoTest_UDPFailedSkipTests object:nil];
    
    [[NSNotificationCenter defaultCenter] addObserver:self.m_runTestView selector:@selector(locationDidUpdated:) name:LocationDidUpdateNotification object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self.m_runTestView selector:@selector(processFinalResultDidFinish:) name:FTPUploadCompliteNotification object:nil];
    
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(lockPagingScroll) name:LockMainPagingScrollViewNotification object:nil];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(unlockPagingScroll) name:UnLockMainPagingScrollViewNotification object:nil];
}

-(void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
}

-(void)viewDidLayoutSubviews
{
    [super viewDidLayoutSubviews];
    
    CGRect screenBounds = [[UIScreen mainScreen] bounds];

    CGRect frame = CGRectMake(0, 20, screenBounds.size.width, 44);
    self.m_horizontalMenuTableView.frame = frame;
    
    self.m_horizontalMenuTableView.bounds = CGRectMake(0, 0, screenBounds.size.width, 44);
    
    CGRect bounds = self.m_horizontalMenuTableView.bounds;
    bounds.size = CGSizeMake(frame.size.height, frame.size.width); 
    self.m_horizontalMenuTableView.bounds = bounds;
    
    [self.view layoutSubviews];
}


-(void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    [[NSNotificationCenter defaultCenter] removeObserver:self.m_runTestView name:kSKAAutoTest_UDPFailedSkipTests object:nil];
    [[NSNotificationCenter defaultCenter] removeObserver:self.m_runTestView name:LocationDidUpdateNotification object:nil];
    [[NSNotificationCenter defaultCenter] removeObserver:self.m_runTestView name:FTPUploadCompliteNotification object:nil];
    [[NSNotificationCenter defaultCenter] removeObserver:self name:LockMainPagingScrollViewNotification object:nil];
    [[NSNotificationCenter defaultCenter] removeObserver:self name:UnLockMainPagingScrollViewNotification object:nil];
    
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender
{
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

-(void)rotateMenuTableView
{
    [self.m_horizontalMenuTableView setTransform:CGAffineTransformMakeRotation(-M_PI_2)];
    
//    CGRect tFrame = self.m_horizontalMenuTableView.frame;
//    tFrame.size = CGSizeMake(tFrame.size.height, tFrame.size.width);
//    tFrame.origin = CGPointMake(28, 0);
//    self.m_horizontalMenuTableView.frame = tFrame;
    
    self.m_horizontalMenuTableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self.m_horizontalMenuTableView setShowsVerticalScrollIndicator:NO];
    [self.m_horizontalMenuTableView setDecelerationRate: UIScrollViewDecelerationRateFast];
}

#pragma mark - lock scrollView noti
-(void)lockPagingScroll
{
    [self.m_horizontalMenuTableView setUserInteractionEnabled:NO];
    self.m_contentsPagingScrollView.scrollEnabled = NO;
}

-(void)unlockPagingScroll
{
    [self.m_horizontalMenuTableView setUserInteractionEnabled:YES];
    self.m_contentsPagingScrollView.scrollEnabled = YES;
}

#pragma mark - Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [m_menuTitleArr count];
}

- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section
{
    return @"";
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
        return self.view.frame.size.width / m_menuTitleArr.count;
    else
        return self.view.frame.size.width / 3;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *CellIdentifier = @"MenuTableViewCell";
    
    MenuTableViewCell *menuCell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (menuCell == nil) {
        NSArray *nib = [[NSBundle mainBundle] loadNibNamed:@"MenuTableViewCell" owner:self options:nil];
        
        for (id oneObject in nib)
            if ([oneObject isKindOfClass:[MenuTableViewCell class]])
                menuCell = (MenuTableViewCell *)oneObject;
        
        UIImageView *menuCellBgView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"MainPaging_Menu_Default"]];
        menuCell.backgroundView = menuCellBgView;
        UIImageView *menuCellSelBgView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"MainPaging_Menu_Selected"]];
        menuCell.selectedBackgroundView = menuCellSelBgView;
//        menuCell.backgroundColor = [UIColor yellowColor];
        
        
        [menuCell setTransform:CGAffineTransformMakeRotation(M_PI_2)];
    }
    
    [menuCell.menuLabel setFont:[UIFont boldSystemFontOfSize:14]];
    [menuCell.menuLabel setTextColor:UIColorFromRGB(0x4e4e4e)];
    menuCell.menuLabel.text = [m_menuTitleArr objectAtIndex:indexPath.row];
    return menuCell;
}

#pragma mark - Table view delegate
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView scrollToRowAtIndexPath:indexPath
                     atScrollPosition:UITableViewScrollPositionMiddle
                             animated:YES];
    
    CGPoint offset = CGPointMake(self.m_contentsPagingScrollView.frame.size.width * indexPath.row, 0);
//        [self.m_contentsPagingScrollView setContentOffset:offset animated:YES];
    [self.m_contentsPagingScrollView setContentOffset:offset];
}

#pragma mark - UIScrollViewDelegate
- (void)scrollViewDidScroll:(UIScrollView *)scrollView
{
    if([scrollView isEqual:self.m_horizontalMenuTableView])
    {
//        if(scrollView.contentOffset.y >= round(scrollView.contentSize.height - scrollView.frame.size.width))
//        {
//            [self.mMenuRightBtn setEnabled:NO];
//        }
//        else if(scrollView.contentOffset.y <= 0)
//        {
//            [self.mMenuLeftBtn setEnabled:NO];
//        }
//        else
//        {
//            [self.mMenuLeftBtn setEnabled:YES];
//            [self.mMenuRightBtn setEnabled:YES];
//        }
    }
    else //contents scroll view
    {
        CGFloat width = self.m_contentsPagingScrollView.frame.size.width;
        CGPoint offset = self.m_contentsPagingScrollView.contentOffset;        
//        NSInteger pageNo = offset.x / width;
        NSInteger pageNo = ((offset.x - width/2) / width) + 1;
        
        NSIndexPath *indexPath = [NSIndexPath indexPathForRow:pageNo inSection:0];
        
        [self.m_horizontalMenuTableView selectRowAtIndexPath:indexPath animated:YES scrollPosition:UITableViewScrollPositionMiddle];
        
    }
}

@end
