//
//  MobileDataResetDayPopupViewController.m
//  SKCore
//
//  Created by KSW on 2015. 1. 26..
//  Copyright (c) 2015 SamKnows. All rights reserved.
//

#import "MobileDataResetDayPopupViewController.h"

@interface MobileDataResetDayPopupViewController ()

@end

@implementation MobileDataResetDayPopupViewController

- (void)viewDidLoad
{
    [super viewDidLoad];

    m_resetDayDic = [[NSMutableDictionary alloc] initWithDictionary:[SKGlobalMethods loadMobileDataResetDayInfo]];
    m_resetDay = [[m_resetDayDic objectForKey:@"settedResetDay"] intValue];
    
    [self.resetDaySlider setValue:m_resetDay animated:YES];
    [self updateResetDayLabel];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
}

- (IBAction)setDefaultButtonClicked:(id)sender
{
    m_resetDay = [[m_resetDayDic objectForKey:@"defualtResetDay"] intValue];
    
    [self.resetDaySlider setValue:m_resetDay animated:YES];
    [self updateResetDayLabel];
}

- (IBAction)cancelButtonClicked:(id)sender
{
    [self.delegate dismissMobileDataResetDayPopupView];
}

- (IBAction)okButtonClicked:(id)sender
{
    NSDate *today = [NSDate date];
    int dayOftoDay = (int)[today mt_dayOfMonth];
    
    NSDate *nextResetDay;
    
    if (m_resetDay > dayOftoDay)
    {
        nextResetDay = [NSDate mt_dateFromYear:today.mt_year month:today.mt_monthOfYear day:m_resetDay];
    }
    else
    {
        NSDate *nextMonthDay = [[NSDate date] mt_startOfNextMonth];
        nextResetDay = [NSDate mt_dateFromYear:nextMonthDay.mt_year month:nextMonthDay.mt_monthOfYear day:m_resetDay];
    }
 
    [m_resetDayDic setObject:nextResetDay forKey:@"nextResetDay"];
    [m_resetDayDic setObject:[NSString stringWithFormat:@"%d", m_resetDay] forKey:@"settedResetDay"];
    [SKGlobalMethods saveMobileDataResetDay:m_resetDayDic];
    
    [self.delegate dismissMobileDataResetDayPopupView];
}

- (IBAction)resetDaySliderValueChanged:(UISlider*)sender
{
    m_resetDay = (int)sender.value;
    [self updateResetDayLabel];
}

-(void)updateResetDayLabel
{
    self.resetDayLabel.text = [NSString stringWithFormat:NSLocalizedString(@"Day of Month: %dst", nil), m_resetDay];
}
@end
