//
//  NormalModeSettingView.m
//  SKCore
//
//  Created by jungeol.park on 2015. 1. 23..
//  Copyright (c) 2015 ACCVUER. All rights reserved.
//

#import "NormalModeSettingView.h"
#import "TitleAndDetailTextCell.h"
#import "UIViewController+MJPopupViewController.h"
#import "MainPagingScrollViewController.h"

@implementation NormalModeSettingView

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super initWithCoder:aDecoder];
    if(self)
    {
        
    }
    return self;
}

-(void)initViews
{
    self.m_settingTableView.delegate = self;
    self.m_settingTableView.dataSource = self;
    self.m_settingTableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    
    [self reloadNormalModeSettingViews];
}

-(void)reloadNormalModeSettingViews
{
    // mobile data usage reset day cell data
    NSDictionary *resetDayInfo = [SKGlobalMethods loadMobileDataResetDayInfo];
    int resetDay = [[resetDayInfo objectForKey:@"settedResetDay"] intValue];
    m_resetDayTitle = [NSString stringWithFormat:NSLocalizedString(@"Mobile data usage reset day: %dst", nil), resetDay];
    m_resetDayDesc = NSLocalizedString(@"ModbileDataResetDayDesc", nil);
    
    // mobile data cap cell data
    unsigned int dataCap = [SKGlobalMethods loadMobileDataCap];
    m_dataCapTitle = [NSString stringWithFormat:NSLocalizedString(@"Mobile data cap: %dMB", nil), dataCap];
    m_dataCapDesc = NSLocalizedString(@"MobileDataCapDesc", nil);
    
    unsigned long long dataUsed = [SKGlobalMethods loadMobileDataUsed];
    NSString *valueString = [SKGlobalMethods bytesToString:(double)dataUsed];
    m_dataUsedTitle = [NSString stringWithFormat:NSLocalizedString(@"Data Used %@", nil), valueString];
    m_dataUsedDesc = NSLocalizedString(@"DataUsedDesc", nil);
    
    [self.m_settingTableView reloadData];
}

#pragma mark - Table view data source
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 3;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSInteger row = indexPath.row;
    
    
//    if (row == 3)
//        return 44;
    
    
    // 
    
    int gap = 10;
    static NSString *CellIdentifier = @"TitleAndDetailTextCell";
    
    TitleAndDetailTextCell *titleDetailLabelCell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (titleDetailLabelCell == nil) {
        NSArray *nib = [[NSBundle mainBundle] loadNibNamed:@"TitleAndDetailTextCell" owner:self options:nil];
        
        for (id oneObject in nib)
            if ([oneObject isKindOfClass:[TitleAndDetailTextCell class]])
                titleDetailLabelCell = (TitleAndDetailTextCell *)oneObject;
    }
    
    if (row == 0)
    {
        CGFloat movedHeight = 0.0f;
        CGRect rect = titleDetailLabelCell.detailLabel.frame;

        CGFloat detailTextLabelHeight = [SKGlobalMethods
                                         calculateHeightOfTextLabel:m_dataUsedDesc
                                         withFont:titleDetailLabelCell.detailLabel.font
                                         withWidth:titleDetailLabelCell.detailLabel.frame.size.width
                                         withlineBreakMode:titleDetailLabelCell.detailLabel.lineBreakMode];
        
        if (detailTextLabelHeight < rect.size.height)
            detailTextLabelHeight = rect.size.height;
        
        if (detailTextLabelHeight != rect.size.height)
        {
            movedHeight = detailTextLabelHeight - rect.size.height;
            rect.size.height = detailTextLabelHeight;
        }
        
        return movedHeight + titleDetailLabelCell.frame.size.height + gap;
    }
    else if (indexPath.row == 1)
    {
        CGFloat movedHeight = 0.0f;
        CGRect rect = titleDetailLabelCell.detailLabel.frame;
        
        CGFloat detailTextLabelHeight = [SKGlobalMethods
                                         calculateHeightOfTextLabel:m_dataCapDesc
                                         withFont:titleDetailLabelCell.detailLabel.font
                                         withWidth:titleDetailLabelCell.detailLabel.frame.size.width
                                         withlineBreakMode:titleDetailLabelCell.detailLabel.lineBreakMode];
        
        if (detailTextLabelHeight < rect.size.height)
            detailTextLabelHeight = rect.size.height;
        
        if (detailTextLabelHeight != rect.size.height)
        {
            movedHeight = detailTextLabelHeight - rect.size.height;
            rect.size.height = detailTextLabelHeight;
        }
        
        return movedHeight + titleDetailLabelCell.frame.size.height + gap;
    }
    else //if (indexPath.row == 2)
    {
        CGFloat movedHeight = 0.0f;
        CGRect rect = titleDetailLabelCell.detailLabel.frame;
        
        CGFloat detailTextLabelHeight = [SKGlobalMethods
                                         calculateHeightOfTextLabel:m_resetDayDesc
                                         withFont:titleDetailLabelCell.detailLabel.font
                                         withWidth:titleDetailLabelCell.detailLabel.frame.size.width
                                         withlineBreakMode:titleDetailLabelCell.detailLabel.lineBreakMode];
        
        if (detailTextLabelHeight < rect.size.height)
            detailTextLabelHeight = rect.size.height;
        
        if (detailTextLabelHeight != rect.size.height)
        {
            movedHeight = detailTextLabelHeight - rect.size.height;
            rect.size.height = detailTextLabelHeight;
        }
        
        return movedHeight + titleDetailLabelCell.frame.size.height + gap;
    }
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSInteger row = indexPath.row;

//    if (row == 3)
//    {
//        static NSString *CellIdentifier = @"Cell";
//
//        UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
//        if (cell == nil) {
//            cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
//                                          reuseIdentifier:CellIdentifier];
//        }
//        
//        cell.textLabel.text = NSLocalizedString(@"Terms of Use", nil);
//        
//        return cell;
//    }

    static NSString *CellIdentifier = @"TitleAndDetailTextCell";
    
    TitleAndDetailTextCell *titleDetailLabelCell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (titleDetailLabelCell == nil) {
        NSArray *nib = [[NSBundle mainBundle] loadNibNamed:@"TitleAndDetailTextCell" owner:self options:nil];
        
        for (id oneObject in nib)
            if ([oneObject isKindOfClass:[TitleAndDetailTextCell class]])
                titleDetailLabelCell = (TitleAndDetailTextCell *)oneObject;
    }
    
    
    if(row == 0)
    {
        CGRect rect = titleDetailLabelCell.detailLabel.frame;
        CGFloat detailTextLabelHeight = [SKGlobalMethods
                                         calculateHeightOfTextLabel:m_dataUsedDesc
                                         withFont:titleDetailLabelCell.detailLabel.font
                                         withWidth:titleDetailLabelCell.detailLabel.frame.size.width
                                         withlineBreakMode:titleDetailLabelCell.detailLabel.lineBreakMode];
        
        if (detailTextLabelHeight < rect.size.height)
            detailTextLabelHeight = rect.size.height;
        
        if (detailTextLabelHeight != rect.size.height)
            rect.size.height = detailTextLabelHeight;
        
        titleDetailLabelCell.detailLabel.frame = rect;
        
        titleDetailLabelCell.titleLabel.text = m_dataUsedTitle;
        titleDetailLabelCell.detailLabel.text = m_dataUsedDesc;
    }
    else if(row == 1)
    {
        CGRect rect = titleDetailLabelCell.detailLabel.frame;
        CGFloat detailTextLabelHeight = [SKGlobalMethods
                                         calculateHeightOfTextLabel:m_dataCapDesc
                                         withFont:titleDetailLabelCell.detailLabel.font
                                         withWidth:titleDetailLabelCell.detailLabel.frame.size.width
                                         withlineBreakMode:titleDetailLabelCell.detailLabel.lineBreakMode];
        
        if (detailTextLabelHeight < rect.size.height)
            detailTextLabelHeight = rect.size.height;
        
        if (detailTextLabelHeight != rect.size.height)
            rect.size.height = detailTextLabelHeight;
        
        titleDetailLabelCell.detailLabel.frame = rect;
        
        titleDetailLabelCell.titleLabel.text = m_dataCapTitle;
        titleDetailLabelCell.detailLabel.text = m_dataCapDesc;
    }
    else// if(row == 2)
    {
        CGRect rect = titleDetailLabelCell.detailLabel.frame;
        CGFloat detailTextLabelHeight = [SKGlobalMethods
                                         calculateHeightOfTextLabel:m_resetDayDesc
                                         withFont:titleDetailLabelCell.detailLabel.font
                                         withWidth:titleDetailLabelCell.detailLabel.frame.size.width
                                         withlineBreakMode:titleDetailLabelCell.detailLabel.lineBreakMode];
        
        if (detailTextLabelHeight < rect.size.height)
            detailTextLabelHeight = rect.size.height;
        
        if (detailTextLabelHeight != rect.size.height)
            rect.size.height = detailTextLabelHeight;
        
        titleDetailLabelCell.detailLabel.frame = rect;
        
        titleDetailLabelCell.titleLabel.text = m_resetDayTitle;
        titleDetailLabelCell.detailLabel.text = m_resetDayDesc;
    }
    
    return titleDetailLabelCell;
}

-(void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    NSInteger row = indexPath.row;
    
    if (row == 0)
    {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:NSLocalizedString(@"Data Used", nil)
                                                        message:NSLocalizedString(@"resetDataUsedAlertMsg", nil)
                                                       delegate:self
                                              cancelButtonTitle:NSLocalizedString(@"MenuAlert_Cancel", nil)
                                              otherButtonTitles:NSLocalizedString(@"MenuAlert_OK", nil), nil];
        [alert show];
    }
    else if (row == 1)
    {
        UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Main" bundle:[NSBundle mainBundle]];
        MobileCapPopupViewController *vc = [storyboard instantiateViewControllerWithIdentifier:@"MobileCapPopupViewController"];
        
        vc.delegate = self;
        
        if([SKAAppDelegate getAppDelegate].mainPagingScrollVC != nil)
            [[SKAAppDelegate getAppDelegate].mainPagingScrollVC presentPopupViewController:vc animationType:MJPopupViewAnimationSlideBottomBottom isEnableBgTouch:NO];
    }
    else if (row == 2)
    {
        UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Main" bundle:[NSBundle mainBundle]];
        MobileDataResetDayPopupViewController *vc = [storyboard instantiateViewControllerWithIdentifier:@"MobileDataResetDayPopupViewController"];
        
        vc.delegate = self;
        
        if([SKAAppDelegate getAppDelegate].mainPagingScrollVC != nil)
            [[SKAAppDelegate getAppDelegate].mainPagingScrollVC presentPopupViewController:vc animationType:MJPopupViewAnimationSlideBottomBottom isEnableBgTouch:NO];
    }
    else //if (row == 3)
    {
        }
}

#pragma mark - UIAlerView delgate
-(void)alertView:(UIAlertView *)alertView didDismissWithButtonIndex:(NSInteger)buttonIndex
{
    if (buttonIndex != alertView.cancelButtonIndex)
    {
        [SKGlobalMethods saveMobileDataUsed:0];
        [self reloadNormalModeSettingViews];
    }
}


#pragma mark - MobileCapPopupViewDelegate
-(void)dismissMobileCapPopupView
{
    [[SKAAppDelegate getAppDelegate].mainPagingScrollVC dismissPopupViewControllerWithanimationType:MJPopupViewAnimationSlideBottomBottom];
    [self reloadNormalModeSettingViews];
}

#pragma mark - MobileDataResetDayPopupViewDelegate
-(void)dismissMobileDataResetDayPopupView
{
    [[SKAAppDelegate getAppDelegate].mainPagingScrollVC dismissPopupViewControllerWithanimationType:MJPopupViewAnimationSlideBottomBottom];
    [self reloadNormalModeSettingViews];
}
@end
