//
//  RunTestView.h
//  SKCore
//
//  Created by jungeol.park on 2014. 9. 3..
//  Copyright (c) 2014 ACCVUER. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "SpeedMeterView.h"
#import "ProgressBar.h"
#import "HTTPRequest.h"
#import "TransferWaitingQueuePopupViewController.h"


@interface RunTestView : UIView <SKAutotestObserverDelegate, HTTPRequestDelegate, TransferWaitingQueuePopupViewDelegate>
{
    BOOL m_testsComplete;
    
    int64_t m_dataStart;
    int64_t m_dataEnd;
    
    TestType m_testType;
    SKAAutotest *m_autoTest;
    
    SKAAppDelegate *m_appDelegate;
    
    NSInteger m_totalTransferedBytes; 
    NSInteger m_caculatedBytes; 
    NSInteger m_timerFireCount;
    double m_bestOneSecThroughput_1024based;
    double m_avgThroughput_1024based;
    
    NSTimer *m_transferUiUpdateTimer;
    BOOL m_isTransferStarted;
    BOOL m_isDownstream;
    NSMutableArray *m_receivedLatencyArr;
    
    int m_autoRepeatIdleTime;
    int m_autoRepeatCount_saved; 
    
    HTTPRequest *m_transferWaitingQueueRequestor;
    TransferWaitingQueuePopupViewController *m_waitingPopupVC;
    BOOL m_isWaitingPopupViewShowing;
    BOOL m_isWaitingPopupViewCanceled;     
}

@property (strong, nonatomic) IBOutlet UILabel *serverNameLabel;
@property (strong, nonatomic) IBOutlet UILabel *operatorAndNetworkLabel;
@property (strong, nonatomic) IBOutlet UILabel *locationLabel;

@property (strong, nonatomic) IBOutlet UILabel *currentTestValueLabel;
@property (strong, nonatomic) IBOutlet UILabel *currentMeasurementUnitLabel;

@property (strong, nonatomic) IBOutlet UILabel *downloadAvgLabel;
@property (strong, nonatomic) IBOutlet UILabel *downloadPeakLabel;
@property (strong, nonatomic) IBOutlet UILabel *uploadAvgLabel;
@property (strong, nonatomic) IBOutlet UILabel *uploadPeakLabel;
@property (strong, nonatomic) IBOutlet UILabel *latencyLabel;
@property (strong, nonatomic) IBOutlet UILabel *packetLossLabel;
@property (strong, nonatomic) IBOutlet UILabel *downloadFailLabel;
@property (strong, nonatomic) IBOutlet UILabel *uploadFailLabel;
@property (strong, nonatomic) IBOutlet UILabel *latencyFailLabel;
@property (strong, nonatomic) IBOutlet UILabel *packetlossFailLabel;

@property (strong, nonatomic) IBOutlet UIButton *startBtn;
@property (strong, nonatomic) IBOutlet UIButton *stopBtn;

@property (strong, nonatomic) IBOutlet SpeedMeterView *speedMeterView;
@property (strong, nonatomic) IBOutlet ProgressBar *downloadProgressView;
@property (strong, nonatomic) IBOutlet ProgressBar *uploadProgressView;
@property (strong, nonatomic) IBOutlet ProgressBar *latencyProgressView;
@property (strong, nonatomic) IBOutlet ProgressBar *packetLossProgressView;

- (IBAction)startButtonClicked:(id)sender;
- (IBAction)stopButtonClicked:(id)sender;

-(void)initViews;
-(void)locationDidUpdated:(NSNotification *)note;
- (void)udpTestFailedSkipTests:(NSNotification*)note;
-(void)reloadAutoRepeatInfo;
@end

