//
//  RunTestView.m
//  SKCore
//
//  Created by jungeol.park on 2014. 9. 3..
//  Copyright (c) 2014 ACCVUER. All rights reserved.
//

#import "RunTestView.h"
#import "HTTPRequest.h"
#import "MainPagingScrollViewController.h"
#import "TransferWaitingQueuePopupViewController.h"
#import "UIViewController+MJPopupViewController.h"
#import "FTPLogger.h"


#define SPEED_METER_START_DEGREE 90
#define SPEED_METER_END_DEGREE 270
#define DEFAULT_SPEED_METER_MIN_VALUE 0 
#define ALERT_TAG_TEST_CANCEL 1
#define ALERT_TAG_REQUEST_TRANSFER_WAITING_QUEUE_ERROR 2
#define ALERT_TAG_MOBILE_DATA_CAP_EXCEED_START_BUTTON 3
#define ALERT_TAG_MOBILE_DATA_CAP_EXCEED_AUTO_REPEAT 4


@implementation RunTestView
@synthesize speedMeterView;

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self)
    {
    }
    return self;
}

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super initWithCoder:aDecoder];
    if(self)
    {
        m_appDelegate = (SKAAppDelegate*)[UIApplication sharedApplication].delegate;
        
        
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(reachabilityChanged:) name:kReachabilityChangedNotification object:nil];
        
        [self reloadAutoRepeatInfo];
    }
    return self;
}

-(void)reloadAutoRepeatInfo
{
    NSMutableDictionary *scenarioDic = [m_appDelegate.testSchedule_new getScenarioDic];
    if (scenarioDic == nil)
    {
        [self showConfigLoadErrorAlert];
        return;
    }
    
    NSDictionary *commonInfoDic = [scenarioDic objectForKey:@"Common"];
    if(commonInfoDic == nil)
    {
        [self showConfigLoadErrorAlert];
        return;
    }
    NSString *bestServerName = [m_appDelegate.testSchedule_new getClosestTargetName:[m_appDelegate amdGetClosestTarget]];
    [m_appDelegate.testSchedule_new poplateAllTestsInfoWithBestServer:bestServerName];
    
    NSLog(@"reloadAutoRepeatInfo %@", commonInfoDic);
    
    m_isAutoRepeat = [[commonInfoDic objectForKey:@"Autorepeat"] boolValue];
    m_autoRepeatCount_saved = [[commonInfoDic objectForKey:@"Count"] intValue];
//    m_autoRepeatIdleTime = [[commonInfoDic objectForKey:@"Idel"] intValue];
    m_autoRepeatIdleTime = [[commonInfoDic objectForKey:@"Idel"] intValue] * 60; 
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect
{
    // Drawing code
}
*/

-(void)locationDidUpdated:(NSNotification *)note
{
    if ([note.object isKindOfClass:[CLLocation class]])
    {
        CLLocation *loc = (CLLocation*)note.object;
        if (loc != nil)
            [self updateLocationLabelWithLoc:loc];
    }
}

- (void)reachabilityChanged:(NSNotification*)note
{
    [m_appDelegate reachabilityChanged:note];
    [self updateOperatorAndNetworkTechLabel];
}

#pragma mark -
#pragma mark -
#pragma mark -
#pragma mark -
#pragma mark -
#pragma mark - Transfer waiting queue http request

-(void) httpRequest_endTransferSession
{
    HTTPRequest *request = [[HTTPRequest alloc] init];
    [request requestEndTransferSession];
}

-(void)httpRequest_transferWaitingQueuePosition
{
    [self stopTransferWaitingQueueRequest];
    
    [self stopAutoRepeatTimer];
    
    if (m_transferWaitingQueueRequestor == nil)
    {
        m_transferWaitingQueueRequestor = [[HTTPRequest alloc] init];
        m_transferWaitingQueueRequestor.delgate = self;
        [m_transferWaitingQueueRequestor requestTransferWaitingQueue];
    }
}

-(void)stopTransferWaitingQueueRequest
{
    if (m_transferWaitingQueueRequestor != nil)
    {
        [m_transferWaitingQueueRequestor stopRequestTransferWaitingQueue];
        m_transferWaitingQueueRequestor = nil;
    }
}

#pragma mark - HTTPRequestDelegate
-(void)didReceiveTransferWaitingQueueResponsWithPosition:(NSInteger)position
                                               withError:(TransferWaitingQueueErrorType)errorType
{
    if(errorType == TransferWaitingQueueErrorType_None)
    {
        if (position == -1) 
            position = 100;
        
        if(position == 0)
        {
            if (m_isWaitingPopupViewShowing)          {
                if (m_waitingPopupVC != nil)
                {
                    [m_appDelegate.mainPagingScrollVC dismissPopupViewControllerWithanimationType:MJPopupViewAnimationSlideBottomBottom];
                    m_waitingPopupVC = nil;
                }
                else
                {
                    [self runTests:ALL_TESTS];
                }
                
                m_isWaitingPopupViewShowing = NO;
            }
            else 
            {
                [self runTests:ALL_TESTS];
            }
        }
        else
        {
            if(m_isWaitingPopupViewShowing == NO)
            {
                UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Main" bundle:[NSBundle mainBundle]];
                m_waitingPopupVC = [storyboard instantiateViewControllerWithIdentifier:@"TransferWaitingQueuePopupViewController"];
                m_waitingPopupVC.delegate = self;
                m_waitingPopupVC.position = position;
                [m_appDelegate.mainPagingScrollVC presentPopupViewController:m_waitingPopupVC
                                                               animationType:MJPopupViewAnimationSlideBottomBottom
                                                             isEnableBgTouch:NO
                                                                   dismissed:^{
                                                                       if(m_isWaitingPopupViewCanceled)
                                                                           [self resetUiWhenAllTestDone];
                                                                       else
                                                                            [self runTests:ALL_TESTS];
                                                                       
                                                                       m_isWaitingPopupViewCanceled = NO;
                                                                   }];
                m_isWaitingPopupViewShowing = YES;
            }
            else
            {
                if(m_waitingPopupVC != nil)
                   [m_waitingPopupVC updatePositionLabel:position];
            }
        }
    }
    else
    {
        [self stopTransferWaitingQueueRequest];
        
        if(m_isAutoRepeat)
        {
            [self makeFakeFailResult];
        }
        else
        {
            UIAlertView *alert = [[UIAlertView alloc] initWithTitle:NSLocalizedString(@"Preparing for measurement", nil)
                                                            message:NSLocalizedString(@"TransferWaitingQueueErrorMsg", nil)
                                                           delegate:self
                                                  cancelButtonTitle:NSLocalizedString(@"MenuAlert_Cancel", nil)
                                                  otherButtonTitles:NSLocalizedString(@"MenuAlert_Retry", nil), nil];
            alert.tag = ALERT_TAG_REQUEST_TRANSFER_WAITING_QUEUE_ERROR;
            [alert show];
        }
    }
}

#pragma mark - TransferWaitingQueuePopupView delegate
-(void)cancelTransferWaitingQueuRequest
{
    [self stopTransferWaitingQueueRequest];
    
    m_isWaitingPopupViewCanceled = YES;
    [m_appDelegate.mainPagingScrollVC dismissPopupViewControllerWithanimationType:MJPopupViewAnimationSlideBottomBottom];
    m_waitingPopupVC = nil;
    m_isWaitingPopupViewShowing = NO;
}

#pragma mark -
#pragma mark -
#pragma mark -
#pragma mark -
#pragma mark - Test controll

#pragma mark - button action
- (IBAction)startButtonClicked:(id)sender
{
    if ([self needShowMobileDataExceededAlertWithIsAutoRepeat:NO] == NO)
        [self startTextWithStartButtonClick];
}

- (IBAction)stopButtonClicked:(id)sender
{
    [self showStopAlert];
}

-(unsigned long long)caculateTotalNetworkTrafficPerTest
{
    unsigned long long total = 0;
    NSMutableDictionary *scenarioDic = [m_appDelegate.testSchedule_new getScenarioDic];
    
    // latency test
    NSDictionary *latencyDic = [scenarioDic objectForKey:@"Latency"];
    if (latencyDic != nil)
    {
        int latencyPacketCount = [[latencyDic objectForKey:@"numberOfPacket"] intValue];
        total += (latencyPacketCount * 16);
    }
    
    NSDictionary *dnDic = [scenarioDic objectForKey:@"Download"];
    if (dnDic != nil)
    {
        long dnByte = [[dnDic objectForKey:@"Filesize"] intValue] * 1048576;
        int sessionCount = [[dnDic objectForKey:@"Session"] intValue];
        int dnRepeatCount = [[dnDic objectForKey:@"Count"] intValue];
        
        total += dnByte * sessionCount * dnRepeatCount;
    }
    
    NSDictionary *ulDic = [scenarioDic objectForKey:@"Download"];
    if (ulDic != nil)
    {
        long ulByte = [[ulDic objectForKey:@"Filesize"] intValue] * 1048576;
        int sessionCount = [[ulDic objectForKey:@"Session"] intValue];
        int ulRepeatCount = [[ulDic objectForKey:@"Count"] intValue];
        
        total += ulByte * sessionCount * ulRepeatCount;
    }
    
    return total;
}

#pragma mark - start test
-(void)startTextWithStartButtonClick
{
    [[NSNotificationCenter defaultCenter] postNotificationName:LockMainPagingScrollViewNotification object:nil];
    
    [self resetViews];
    
    [UIView beginAnimations:nil context:nil];
    [UIView setAnimationDuration:0.3];
    [self showStartBtn:NO];
    [UIView commitAnimations];
    
    m_autoRepeatCount_use = m_autoRepeatCount_saved;
    
    [self httpRequest_transferWaitingQueuePosition];
}

- (void)runTests:(TestType)type
{
    
    if ([m_appDelegate amdGetFileUploadPath] == nil) {
        // File not yet ready - TODO add an alerts to say "Please wait"...?
        SK_ASSERT(false);
        return;
    }
    
    m_testType = type;
    
    if(m_isAutoRepeat)
    {
        [self startToRunTheTests];
    }
    else
    {
        if ([m_appDelegate getIsConnected])
        {
            [self startToRunTheTests];
        }
        else
        {
            UIAlertView *alert =
            [[UIAlertView alloc] initWithTitle:nil
                                       message:NSLocalizedString(@"Offline_message", nil)
                                      delegate:nil
                             cancelButtonTitle:NSLocalizedString(@"MenuAlert_OK",nil)
                             otherButtonTitles: nil];
            
            [alert show];
        }
    }
}

-(void) startToRunTheTests
{
    [self resetViews];
    [self initTextLabelWhenTestStarts];
    
    m_testsComplete = NO;
    
    // Either user tried to kick-off tests when connected, or we're continuing a continuous test.
    // Handle this as a separate task, to prevent recursion, as we're running this from WITHIN a test.
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(1.0 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        
        SK_ASSERT([NSThread isMainThread]);
        
        // Defend against running tests more than once, simultaneously!
        [self stopAutoTest];
        
        
        [[TestResultDataCollector sharedInstance] initResultData];
        [TestResultDataCollector sharedInstance].isAutoRepeat = m_isAutoRepeat;
        
        NSString *startTimeStr = [SKGlobalMethods yyyyMMdd_HHmmssStringFormDate:[SKCore getToday]];
        [TestResultDataCollector sharedInstance].StartTime = startTimeStr;
        
        m_autoTest = [[SKAAutotest alloc] initAndRunWithAutotestManagerDelegate:m_appDelegate AndAutotestObserverDelegate:self AndTestType:m_testType IsContinuousTesting:NO];
        
    });
}

#pragma mark - stop test

-(void)stopAutoTest
{
    [self stopTansferingUiUpdateTimer];
    [self initSpinnerValue];
    
    if (m_autoTest != nil) {
        [m_autoTest stopTheTests];
        m_autoTest = nil;
    }
}

-(void)showStopAlert
{
    
    UIAlertView *alert = [[UIAlertView alloc]
                          initWithTitle:NSLocalizedString(@"Tests_Running_Title", nil)
                          message:NSLocalizedString(@"Tests_Running_Message", nil)
                          delegate:self
                          cancelButtonTitle:NSLocalizedString(@"MenuAlert_No",nil)
                          otherButtonTitles:NSLocalizedString(@"MenuAlert_OK",nil),nil];
    alert.tag = ALERT_TAG_TEST_CANCEL;
    [alert show];
}

-(void) alertView:(UIAlertView *)alertView didDismissWithButtonIndex:(NSInteger)buttonIndex
{
    if(alertView.tag == ALERT_TAG_TEST_CANCEL)
    {
        if (buttonIndex != alertView.cancelButtonIndex)
        {
            [self stopTestFromAlertResponse:YES];
        }
    }
    else if (alertView.tag == ALERT_TAG_REQUEST_TRANSFER_WAITING_QUEUE_ERROR)
    {
        if (buttonIndex != alertView.cancelButtonIndex)
        {
            [self httpRequest_transferWaitingQueuePosition];
        }
        else
        {
            if(m_isWaitingPopupViewShowing == YES)
            {
                m_isWaitingPopupViewCanceled = YES;
                [m_appDelegate.mainPagingScrollVC dismissPopupViewControllerWithanimationType:MJPopupViewAnimationSlideBottomBottom];
                m_waitingPopupVC = nil;
                m_isWaitingPopupViewShowing = NO;
            }
            else
            {
                [self resetUiWhenAllTestDone];
            }
        }
    }
    else if (alertView.tag == ALERT_TAG_MOBILE_DATA_CAP_EXCEED_START_BUTTON)
    {
        if (buttonIndex == alertView.cancelButtonIndex)
        {
            [self resetUiWhenAllTestDone];
        }
        else
        {
            [self startTextWithStartButtonClick];
        }
        
    }
    else if (alertView.tag == ALERT_TAG_MOBILE_DATA_CAP_EXCEED_AUTO_REPEAT)
    {
        if (buttonIndex == alertView.cancelButtonIndex)
        {
            [self resetUiWhenAllTestDone];
        }
        else
        {
            [self httpRequest_transferWaitingQueuePosition];
        }
        
    }
}

-(void)stopTansferingUiUpdateTimer
{
    if(m_transferUiUpdateTimer != nil)
    {
        [m_transferUiUpdateTimer invalidate];
        m_transferUiUpdateTimer = nil;
    }
}

-(void)resetUiWhenAllTestDone
{
    [UIView beginAnimations:nil context:nil];
    [UIView setAnimationDuration:0.3];
    [self showStartBtn:YES];
    [UIView commitAnimations];

    [[NSNotificationCenter defaultCenter] postNotificationName:UnLockMainPagingScrollViewNotification object:nil];
}

- (void)stopTestFromAlertResponse:(BOOL)fromAlertResponse
{
    [self stopAutoRepeatTimer];
    [self stopAutoTest];
    [self resetUiWhenAllTestDone];
    
    [[TKAlertCenter defaultCenter] postAlertWithMessage:NSLocalizedString(@"TestDoneMsg", nil)];
    
    SK_ASSERT([NSThread isMainThread]);
    
    m_testsComplete = YES;
}

#pragma mark -
#pragma mark -
#pragma mark -
#pragma mark -
#pragma mark -
#pragma mark - Autotest Delegate Methods

#pragma mark - closet test delegate
// Closest Test /////////////////////////////////////////////////
- (void)aodClosestTargetTestDidStart
{
    //do nothing
}
- (void)aodClosestTargetTestDidFail
{
    //do nothing
}
- (void)aodClosestTargetTestDidSucceed:(NSString*)target
{
    //do nothing
}

#pragma mark - transfer delegate
// TRANSFER //////////////////////////////////////////////////////

- (void)aodTransferTestDidStart:(BOOL)isDownstream
{
    m_isTransferStarted = NO;
    m_isDownstream = isDownstream;
    
    
    if(isDownstream)
    {
        [self.downloadAvgLabel setText:@"-"];
        [self.downloadPeakLabel setText:@"P:"];
        [[TKAlertCenter defaultCenter] postAlertWithMessage:NSLocalizedString(@"PreparingDownloadtMsg", nil)];
        [self.downloadProgressView setHidden:NO];
        [self.downloadFailLabel setHidden:YES];
    }
    else
    {
        [self.uploadAvgLabel setText:@"-"];
        [self.uploadPeakLabel setText:@"P:"];
        [[TKAlertCenter defaultCenter] postAlertWithMessage:NSLocalizedString(@"PreparingUploadtMsg", nil)];
        [self.uploadProgressView setHidden:NO];
        [self.uploadFailLabel setHidden:YES];
    }
    
    
}

-(void) aodTransferTestDidUpdateStatus:(TransferStatus)status threadId:(NSUInteger)threadId
{

    switch (status)
    {
        case TRANSFERRING:
        {
            @synchronized(self)
            {
                if(m_transferUiUpdateTimer == nil)
                {
                    [self initTransferTestThroughputCalculationVariables];
                    
                    NSLog(@);
                    m_isTransferStarted = YES;
                    m_transferUiUpdateTimer = [NSTimer scheduledTimerWithTimeInterval:1 target:self selector:@selector(handelTransferUiUpdateTimer:) userInfo:nil repeats:YES];
                    
                    if (m_isDownstream)
                        [[TKAlertCenter defaultCenter] postAlertWithMessage:NSLocalizedString(@"DLMeasurementStartMsg", nil)];
                    else
                        [[TKAlertCenter defaultCenter] postAlertWithMessage:NSLocalizedString(@"ULMeasurementStartMsg", nil)];
                    
                }
            }
            break;
        }
        case WARMING:
            break;
        case COMPLETE:
            m_isTransferStarted = NO; 
        case CANCELLED:
        case FAILED:
        case FINISHED:
            [self stopTansferingUiUpdateTimer];
            break;
            
        default:
            break;
    }
}

- (void)aodTransferTestDidUpdateProgress:(float)progress isDownstream:(BOOL)isDownstream
{
    if(isDownstream)
    {
        [self.downloadProgressView setProgressValue:(progress/100.0F)];
    }
    else
    {
        [self.uploadProgressView setProgressValue:(progress/100.0F)];
    }
}

- (void)aodTransferTestDidFail:(BOOL)isDownstream
{
    
#ifdef DEBUG
    NSString *test = isDownstream ? @"downstreamthroughput" : @"upstreamthroughput";
    NSLog(@"%s aodTransferTestDidFail : %@", __FUNCTION__, test);
#endif // DEBUG
    
    if (isDownstream)
    {
        [self.downloadFailLabel setHidden:NO];
        [self.downloadAvgLabel setText:@""];
        [self.downloadPeakLabel setText:@""];
        [self.downloadProgressView setProgressValue:0.0f];
        [self.downloadProgressView setHidden:YES];
        
        [TestResultDataCollector sharedInstance].Max_DL_Throughput = TEST_RESULT_FAILED_VALUE_DOUBLE_TYPE; // best
        [[TestResultDataCollector sharedInstance].Avg_DL_Throughput addObject:[NSNumber numberWithDouble:TEST_RESULT_FAILED_VALUE_DOUBLE_TYPE]]; // avg
    }
    else
    {
        [self.uploadFailLabel setHidden:NO];
        [self.uploadAvgLabel setText:@""];
        [self.uploadPeakLabel setText:@""];
        [self.uploadProgressView setProgressValue:0.0f];
        [self.uploadProgressView setHidden:YES];
        
        
        [TestResultDataCollector sharedInstance].Max_UL_Throughput = TEST_RESULT_FAILED_VALUE_DOUBLE_TYPE; // best
        [[TestResultDataCollector sharedInstance].Avg_UL_Throughput addObject:[NSNumber numberWithDouble:TEST_RESULT_FAILED_VALUE_DOUBLE_TYPE]]; // avg
    }
    
    [self initTransferTestThroughputCalculationVariables];
    [self initSpinnerValue];
}

- (void)aodTransferTestDidCompleteTransfer:(BOOL)isDownstream Bitrate1024Based:(double)bitrate1024Based
{
    [self stopTansferingUiUpdateTimer];
    
    double usedAvgBitRate1024Based;
    if(m_avgThroughput_1024based == 0.0f) 
    {
         //
        // B1 + B2 + B3 / MAX(C1, C2, C3)
        // B = Bytes transferred
        // C = The transfer time (without warm up time)
        // 1, 2, 3 = Thread number
        //
        usedAvgBitRate1024Based = bitrate1024Based;
    }
    else
    {
        
        usedAvgBitRate1024Based = m_avgThroughput_1024based;
    }
    
    NSString *result = [SKGlobalMethods bitrateMbps1024BasedToString:usedAvgBitRate1024Based];
#ifdef DEBUG
    NSString *test = isDownstream ? @"downstreamthroughput" : @"upstreamthroughput";
    NSLog(@"************ DEBUG: aodTransferTestDidCompleteTransfer - test=%@, bitrate=%@", test, result);
#endif
    
    double bestOneSecThroughput;
    if (m_bestOneSecThroughput_1024based < 1)
    {
        bestOneSecThroughput = usedAvgBitRate1024Based;
    }
    else
    {
        bestOneSecThroughput = m_bestOneSecThroughput_1024based;
    }
    
    if(isDownstream)
    {
        [self.currentTestValueLabel setText:@""];
        [self.downloadAvgLabel setText:result];
        NSString *bestResult = [NSString stringWithFormat:@"P:%@", [SKGlobalMethods bitrateMbps1024BasedToString:bestOneSecThroughput]];
        [self.downloadPeakLabel setText:bestResult];
        [self.downloadProgressView setProgressValue:(100/100.0F)];
        
        double dlBestBitRate1000Based = [SKGlobalMethods convertMbps1024BasedToMBps1000Based:bestOneSecThroughput];         [TestResultDataCollector sharedInstance].Max_DL_Throughput = dlBestBitRate1000Based; // best
        
        double dlAvgBitRate1000Based = [SKGlobalMethods convertMbps1024BasedToMBps1000Based:usedAvgBitRate1024Based]; 
        [[TestResultDataCollector sharedInstance].Avg_DL_Throughput addObject:[NSNumber numberWithDouble:dlAvgBitRate1000Based]]; // avg
    }
    else
    {
        [self.currentTestValueLabel setText:@""];
        [self.uploadAvgLabel setText:result];
        NSString *bestResult = [NSString stringWithFormat:@"P:%@", [SKGlobalMethods bitrateMbps1024BasedToString:bestOneSecThroughput]];
        [self.uploadPeakLabel setText:bestResult];
        [self.uploadProgressView setProgressValue:(100/100.0F)];
        
        
        double ulBestBitRate1000Based = [SKGlobalMethods convertMbps1024BasedToMBps1000Based:bestOneSecThroughput]; 
        [TestResultDataCollector sharedInstance].Max_UL_Throughput = ulBestBitRate1000Based; // best
        
        double ulAvgBitRate1000Based = [SKGlobalMethods convertMbps1024BasedToMBps1000Based:usedAvgBitRate1024Based];       [[TestResultDataCollector sharedInstance].Avg_UL_Throughput addObject:[NSNumber numberWithDouble:ulAvgBitRate1000Based]]; // avg
    }
    
     [self initTransferTestThroughputCalculationVariables];
    [self initSpinnerValue];
}

-(void)aodTransferTestDidTransferData:(NSUInteger)byteLength isDownstream:(BOOL)isDownstream
{
    @synchronized(self)
    {
        if(m_isTransferStarted)
        {
            m_totalTransferedBytes += byteLength;
            
//            NSLog(@" ", m_totalTransferedBytes, byteLength);
        }
    }
}

#pragma mark calculate transfer throughput per sec and update UI

-(void)initTransferTestThroughputCalculationVariables
{
    m_timerFireCount = 0;
    m_totalTransferedBytes = 0;
    m_caculatedBytes = 0;
    m_bestOneSecThroughput_1024based = 0.0f;
    m_avgThroughput_1024based = 0.0f;
}

-(void)handelTransferUiUpdateTimer:(NSTimer*)theTimer
{
    if(m_isTransferStarted == NO)
        return;
    
    m_timerFireCount++;
    
    NSInteger oneSecTransferedByte = m_totalTransferedBytes - m_caculatedBytes;
    double oneSecThroughput_1024based = [SKGlobalMethods
                                         getBitrateMbps1024BasedDoubleForTransferTimeMicroseconds:[self microTime:1]
                                         transferBytes:oneSecTransferedByte];
    
    m_caculatedBytes = m_totalTransferedBytes;
    
#warning E 1E의 E이 EEE오EEEEE..
    if(m_timerFireCount == 1)
    {
        m_totalTransferedBytes = 0;
        m_caculatedBytes = 0;
        return; 
    }
    
    // peak throughput
    if(m_bestOneSecThroughput_1024based < oneSecThroughput_1024based)
        m_bestOneSecThroughput_1024based = oneSecThroughput_1024based;
    
    
    m_avgThroughput_1024based = [SKGlobalMethods
                                 getBitrateMbps1024BasedDoubleForTransferTimeMicroseconds:[self microTime:m_timerFireCount-1]                                  transferBytes:m_totalTransferedBytes];
    
    // ui update
    [self.speedMeterView setSpinnerValiueWithInstantValue:oneSecThroughput_1024based withAvgValue:m_avgThroughput_1024based];
    NSString *oneSecResult = [SKGlobalMethods bitrateMbps1024BasedToString:oneSecThroughput_1024based];
    [self.currentTestValueLabel setText:oneSecResult];
    if (m_isDownstream)
    {
        [self.downloadAvgLabel setText:[SKGlobalMethods bitrateMbps1024BasedToString:m_avgThroughput_1024based]];
        [self.downloadPeakLabel setText:[SKGlobalMethods bitrateMbps1024BasedToString:m_bestOneSecThroughput_1024based]];
    }
    else
    {
        [self.uploadAvgLabel setText:[SKGlobalMethods bitrateMbps1024BasedToString:m_avgThroughput_1024based]];
        [self.uploadPeakLabel setText:[SKGlobalMethods bitrateMbps1024BasedToString:m_bestOneSecThroughput_1024based]];
    }
    
    
(int)oneSecTransferedByte, oneSecThroughput_1024based, oneSecResult, (int)m_totalTransferedBytes, m_avgThroughput_1024based);
    
}

#pragma mark - latency delegate
// LATENCY //////////////////////////////////////////////////////

- (void)aodLatencyTestDidStart
{
    
    [self httpRequest_endTransferSession];
    
    
    [[TKAlertCenter defaultCenter] postAlertWithMessage:NSLocalizedString(@"PreparingLatencyMsg", nil)];
    
    m_receivedLatencyArr = [[NSMutableArray alloc] init];
    
    [self initSpeedMeterView];
    
    [self.currentMeasurementUnitLabel setText:@"ms"];
    [self.latencyLabel setText:@"-"];
    [self.packetLossLabel setText:@"-"];
    self.latencyProgressView.hidden = NO;
    self.packetLossProgressView.hidden = NO;
    [self.latencyFailLabel setHidden:YES];
    [self.packetlossFailLabel setHidden:YES];
}

-(void)aodLatencyTestDidReceivePackteWithLatency:(double)latency
{
    //    NSLog(@"!!!!!  latencyEE= %2f", latency);
    
    [m_receivedLatencyArr addObject:[NSNumber numberWithDouble:latency]];
    double sum = 0.0f;
    
    for(NSNumber *temp in m_receivedLatencyArr)
    {
        sum += [temp doubleValue];
    }
    double avgLatency = sum / m_receivedLatencyArr.count;
    
    [self.speedMeterView setSpinnerValiueWithInstantValue:latency withAvgValue:avgLatency];
    [self.currentTestValueLabel setText:[NSString stringWithFormat:@"%.1f",latency]];
    [self.latencyLabel setText:[NSString stringWithFormat:@"%.1f",avgLatency]];
}

- (void)udpTestFailedSkipTests:(NSNotification*)note
{
    [self showStoppedLatencyTest];
}

- (void)showStoppedLatencyTest{
    
    // TODO: latecy fail UI update
    [self.latencyFailLabel setHidden:NO];
    [self.latencyLabel setText:@""];
    [self.latencyProgressView setProgressValue:0.0];
    [self.latencyProgressView setHidden:YES];
    
    [self.packetlossFailLabel setHidden:NO];
    [self.packetLossLabel setText:@""];
    [self.packetLossProgressView setProgressValue:0.0];
    [self.packetLossProgressView setHidden:YES];
    
    [self initSpinnerValue];
}

- (void)aodLatencyTestDidFail:(NSString*)messageIgnore
{
    [self showStoppedLatencyTest];
}

- (void)aodLatencyTestDidSucceed:(SKLatencyTest*)latencyTest
{
    double latency = latencyTest.latency;
    
    [self.currentTestValueLabel setText:@""];
    [self.latencyLabel setText:[NSString stringWithFormat:@"%.1f",latency]];
    [self.packetLossLabel setText:[NSString stringWithFormat:@"%.1f", latencyTest.packetLoss]]; // latencyTest.packetLossEEpack loss ratioE.
    [self initSpinnerValue];
    
    [self.latencyProgressView setProgressValue: 1.0f];
    [self.packetLossProgressView setProgressValue: 1.0f];
}

- (void)aodLatencyTestUpdateStatus:(LatencyStatus)status
{
    if (status == INITIALIZING_STATUS)
    {
        [[TKAlertCenter defaultCenter] postAlertWithMessage:NSLocalizedString(@"LatencyMeasurementStartMsg", nil)];
    }
}

- (void)aodLatencyTestWasCancelled
{
    [self initSpinnerValue];
}

- (void)aodLatencyTestUpdateProgress:(float)progress
{
    [self.latencyProgressView setProgressValue: progress/100.0F];
    [self.packetLossProgressView setProgressValue: progress/100.0F];
}


#pragma mark - all tests complete delegate
// ALL TESTS COMPLETE

- (void)aodAllTestsComplete
{
    NSLog(@"all test complete");
    
    [self allTestDidEnded];
}

-(void)allTestDidEnded
{
    
    NSString *endTimeStr = [SKGlobalMethods yyyyMMdd_HHmmssStringFormDate:[SKCore getToday]];
    [TestResultDataCollector sharedInstance].EndTime = endTimeStr;
    
    NSString *dateStr = [SKGlobalMethods yyyyMMdd_HHmmssStringFormDate:[NSDate date]];
    [FTPLogger writeLogToFile:[NSString stringWithFormat:@"\n\n================ %@ Start test result(csv, tsv) processing ==================\n\n", dateStr]];
    
    [[TestResultDataCollector sharedInstance] doProcessFinalResultWithDBIndex:m_autoTest.testId];
}

-(void)processFinalResultDidFinish:(NSNotification*)noti
{
    
    NSString *dateStr = [SKGlobalMethods yyyyMMdd_HHmmssStringFormDate:[NSDate date]];
    [FTPLogger writeLogToFile:[NSString stringWithFormat:@"\n\n================ %@ Stop test result(csv, tsv) processing ==================\n\n", dateStr]];
    
    
    [m_appDelegate.mainPagingScrollVC.m_historyView reloadHistoryTableView];
    
    m_testsComplete = YES;
    [self stopAutoTest];
    
    [[TKAlertCenter defaultCenter] postAlertWithMessage:NSLocalizedString(@"TestDoneMsg", nil)];
    
    SK_ASSERT([NSThread isMainThread]);
     
    
    if (m_isAutoRepeat == YES) {
        
        m_autoRepeatCount_use--;
        if(m_autoRepeatCount_use > 0)
        {
            
            [self startAutoRepeatTimer];
        }
        else
        {
            [self resetUiWhenAllTestDone];
        }
    }
    else
    {
        [self resetUiWhenAllTestDone];
    }
}

#pragma mark -
#pragma mark -
#pragma mark -
#pragma mark -
#pragma mark -
#pragma mark - UI controll
-(void)initViews
{
    [self resetViews];  
    [self initLocationLabel]; 
    [self updateOperatorAndNetworkTechLabel]; 
    [self initStartStopBtns]; 
    [self updateBestServerName]; 
}

-(void)updateBestServerName
{
    NSString *targetName = [m_appDelegate.testSchedule_new getClosestTargetName:[m_appDelegate amdGetClosestTarget]];
    [self.serverNameLabel setText:targetName];
}

-(void)resetViews
{
    [self initSpeedMeterView];

    [self.currentTestValueLabel setText:@""];
    [self.currentMeasurementUnitLabel setText:@"Mbps"];
    
    [self.downloadAvgLabel setText:@""];
    [self.downloadPeakLabel setText:@""];
    [self.uploadAvgLabel setText:@""];
    [self.uploadPeakLabel setText:@""];
    [self.latencyLabel setText:@""];
    [self.packetLossLabel setText:@""];
    
    [self.downloadProgressView setProgressValue: 0];
    [self.downloadProgressView setHidden: YES];
    [self.uploadProgressView setProgressValue: 0];
    [self.uploadProgressView setHidden: YES];
    [self.latencyProgressView setProgressValue: 0];
    [self.latencyProgressView setHidden: YES];
    [self.packetLossProgressView setProgressValue: 0];
    [self.packetLossProgressView setHidden: YES];
    
    [self.downloadFailLabel setHidden:YES];
    [self.uploadFailLabel setHidden:YES];
    [self.latencyFailLabel setHidden:YES];
    [self.packetlossFailLabel setHidden:YES];
}

-(void)initTextLabelWhenTestStarts
{
    [self.currentTestValueLabel setText:@"0.0"];
    [self.currentMeasurementUnitLabel setText:@"Mbps"];
    [self.downloadAvgLabel setText:@"-"];
    [self.downloadPeakLabel setText:@"P:"];
    [self.uploadAvgLabel setText:@"-"];
    [self.uploadPeakLabel setText:@"P:"];
    [self.latencyLabel setText:@"-"];
    [self.packetLossLabel setText:@"-"];
}

-(void)initSpeedMeterView
{
    [self.speedMeterView initSpeedMeterWithBgStartDegree:SPEED_METER_START_DEGREE
                                         withBgEndDegree:SPEED_METER_END_DEGREE];
    self.speedMeterView.m_minValue = DEFAULT_SPEED_METER_MIN_VALUE;
    [self.speedMeterView drawSpeedMeterWithMaxValue:DEFAULT_SPEED_METER_MAX_VALUE];
    [self initSpinnerValue];
}

-(void)initSpinnerValue
{
    [self.speedMeterView setSpinnerValiueWithInstantValue:0.1 withAvgValue:0];
}

-(void)initStartStopBtns
{
    [self showStartBtn:YES];
}

-(void)showStartBtn:(BOOL)isShowStartBtn
{
    if(isShowStartBtn)
    {
        [self.startBtn setHidden:NO];
        [self.stopBtn setHidden:YES];
        
        [self.startBtn setAlpha:1];
        [self.stopBtn setAlpha:0];
    }
    else
    {
        [self.startBtn setHidden:YES];
        [self.stopBtn setHidden:NO];
        
        [self.startBtn setAlpha:0];
        [self.stopBtn setAlpha:1];

    }
}

-(void)updateOperatorAndNetworkTechLabel
{
    NSString *operatorName = [SKGlobalMethods getCarrierName];
    if(operatorName == nil || [operatorName isEqualToString:@""])
        operatorName = STR_NA;
    
    NSString *connStateName = [SKGlobalMethods getConnectionResultString:(ConnectionStatus)[[SKAAppDelegate getAppDelegate] amdGetConnectionStatus]];
    NSString *networkTechName = nil;
    
    if([connStateName isEqualToString:@"MOBILE"])
    {
        NSString *networkType = [SKGlobalMethods getNetworkType];
        networkTechName = [SKGlobalMethods getNetworkTypeLocalized:networkType];
    }
    else
    {
        networkTechName = connStateName;
    }
    
    [self.operatorAndNetworkLabel setText:[NSString stringWithFormat:@"%@ / %@", operatorName, networkTechName]];
    
}

-(void)initLocationLabel
{
    NSUserDefaults *prefs = [NSUserDefaults standardUserDefaults];
    NSDictionary *loc = [prefs objectForKey:Prefs_LastLocation];
    double latitude, longitude;
    BOOL hasLoc = NO;
    if(loc != nil)
    {
        hasLoc = YES;
        latitude = [[loc objectForKey:@"LATITUDE"] doubleValue];
        longitude = [[loc objectForKey:@"LONGITUDE"] doubleValue];
    }
    
    if(hasLoc)
        self.locationLabel.text = [NSString stringWithFormat:NSLocalizedString(@"GPS %.3f / %.3f", nil), latitude, longitude];
    else
        self.locationLabel.text = [NSString stringWithFormat:NSLocalizedString(@"GPS Unknow", nil)];
}


-(void)updateLocationLabelWithLoc:(CLLocation*)loc
{
    CLLocationDegrees latitude = loc.coordinate.latitude;
    CLLocationDegrees longitude = loc.coordinate.longitude;
    
    self.locationLabel.text = [NSString stringWithFormat:NSLocalizedString(@"GPS %.3f / %.3f", nil), latitude, longitude];
}

#pragma mark -
#pragma mark -
#pragma mark -
#pragma mark -
#pragma mark -
#pragma mark - etc
- (SKTimeIntervalMicroseconds)microTime:(NSTimeInterval)time
{
    return time * 1000000.0; // convert to microseconds
}

-(void)showConfigLoadErrorAlert
{
    UIAlertView *alert = [[UIAlertView alloc]
                          initWithTitle:@"information"
                          message:@"load configration failed."
                          delegate:nil
                          cancelButtonTitle:@"Ok"
                          otherButtonTitles:nil];
    [alert show];
}

-(void)startAutoRepeatTimer
{
    [self stopAutoRepeatTimer];
    
    m_autoRepeatStartTimer = [NSTimer scheduledTimerWithTimeInterval:m_autoRepeatIdleTime
                                                              target:self
                                                            selector:@selector(startTest_AutoRepeatCase)
                                                            userInfo:nil
                                                             repeats:NO];

}

-(void)stopAutoRepeatTimer
{
    if (m_autoRepeatStartTimer != nil)
    {
        [m_autoRepeatStartTimer invalidate];
        m_autoRepeatStartTimer = nil;
    }
}

-(void) startTest_AutoRepeatCase
{
    if ([self needShowMobileDataExceededAlertWithIsAutoRepeat:YES] == NO)
        [self httpRequest_transferWaitingQueuePosition];
}


-(BOOL)needShowMobileDataExceededAlertWithIsAutoRepeat:(BOOL)isAutoRepeat
{
    [SKGlobalMethods checkAndResetMobileDataUsage];
    
    if ([SKAAppDelegate getIsUsingWiFi])
    {
        // Ignore if on WiFi!
        return NO;
    }
    
    unsigned long long totalTraffic = [self caculateTotalNetworkTrafficPerTest];
    
    if ([SKGlobalMethods isMobileDataExceeded:totalTraffic])
    {
        UIAlertView *alert = [[UIAlertView alloc]
                              initWithTitle:nil
                              message:NSLocalizedString(@"DataCapExceededAlertMsg", nil)
                              delegate:self
                              cancelButtonTitle:NSLocalizedString(@"MenuAlert_No",nil)
                              otherButtonTitles:NSLocalizedString(@"MenuAlert_OK",nil),nil];
        
        if (isAutoRepeat)
            alert.tag = ALERT_TAG_MOBILE_DATA_CAP_EXCEED_AUTO_REPEAT;
        else
            alert.tag = ALERT_TAG_MOBILE_DATA_CAP_EXCEED_START_BUTTON;
        
        [alert show];
        
        return YES;
    }
    else
    {
        return NO;
    }
}

#pragma mark - make fake fail result

-(void)makeFakeFailResult
{
    [self updateAllTestFailToUi];
    
    [[TestResultDataCollector sharedInstance] initResultData];
    [TestResultDataCollector sharedInstance].isAutoRepeat = m_isAutoRepeat;
    
    NSString *startTimeStr = [SKGlobalMethods yyyyMMdd_HHmmssStringFormDate:[SKCore getToday]];
    [TestResultDataCollector sharedInstance].StartTime = startTimeStr;
    [TestResultDataCollector sharedInstance].EndTime = startTimeStr;
    
    NSString *dateStr = [SKGlobalMethods yyyyMMdd_HHmmssStringFormDate:[NSDate date]];
    [FTPLogger writeLogToFile:[NSString stringWithFormat:@"\n\n================ %@ Start test result(csv, tsv) processing (Test was fail, use fake result on autoRepeat of engineer mode) ==================\n\n", dateStr]];
    
    
    NSNumber *testId = [self getTestIdForDBAtFakeFailCase];
    
    [[TestResultDataCollector sharedInstance] doProcessFinalResultWithDBIndex:testId];
}

-(NSNumber *)getTestIdForDBAtFakeFailCase
{
    double latitude = [m_appDelegate amdGetLatitude];
    double longitude = [m_appDelegate amdGetLongitude];
    
#ifdef USE_NEW_TEST_SCHEDULER
    NewTestScheduler *schedule = m_appDelegate.testSchedule_new;
#else
    SKScheduler *schedule = [autotestManagerDelegate amdGetSchedule];
#endif
    
    NSString *closestTargetName = [m_appDelegate amdGetClosestTarget];
    NSString *targetName = [schedule getClosestTargetName:closestTargetName];
    
    return [SKDatabase
            storeBatchTestMapData:latitude
            longitude:longitude
            target:targetName];
}


-(void)updateAllTestFailToUi
{
    [self.currentTestValueLabel setText:@""];
    
    [self.downloadFailLabel setHidden:NO];
    [self.downloadAvgLabel setText:@""];
    [self.downloadPeakLabel setText:@""];
    [self.downloadProgressView setProgressValue:0.0f];
    [self.downloadProgressView setHidden:YES];
    
    [self.uploadFailLabel setHidden:NO];
    [self.uploadAvgLabel setText:@""];
    [self.uploadPeakLabel setText:@""];
    [self.uploadProgressView setProgressValue:0.0f];
    [self.uploadProgressView setHidden:YES];
    
    [self.latencyFailLabel setHidden:NO];
    [self.latencyLabel setText:@""];
    [self.latencyProgressView setProgressValue:0.0];
    [self.latencyProgressView setHidden:YES];
    
    [self.packetlossFailLabel setHidden:NO];
    [self.packetLossLabel setText:@""];
    [self.packetLossProgressView setProgressValue:0.0];
    [self.packetLossProgressView setHidden:YES];
}

///**
//-(UIImage *)imageWithColor:(UIColor *)color withRect:(CGRect)rect
//{
//    UIGraphicsBeginImageContext(rect.size);
//    CGContextRef ctx = UIGraphicsGetCurrentContext();
//    CGContextSetFillColorWithColor(ctx, [color CGColor]);
//    CGContextFillRect(ctx, rect);
//    UIImage *img = UIGraphicsGetImageFromCurrentImageContext();
//    UIGraphicsEndImageContext();
//    
//    return img;
//}


@end
