//
//  TestGaugeView.h
//  SKCore
//
//  Created by jungeol.park on 2014. 9. 4..
//  Copyright (c) 2014 ACCVUER. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "SpinnerArcLayer.h"


@interface SpeedMeterView : UIView
{
    CGFloat m_width, m_height;
    CGPoint m_center;
    CGFloat m_radius;
    
    CGFloat m_bgStartDegree, m_bgEndDegree;
    CGFloat m_bgStartAngle, m_bgEndAngle;
}
@property (nonatomic) BOOL m_isInited;

@property (nonatomic,assign) float m_maxValue;
@property (nonatomic,assign) float m_minValue;

@property (nonatomic) CALayer *m_containerLayer;
@property (nonatomic) SpinnerArcLayer *m_instantSpinnerArcLayer;
@property (nonatomic) SpinnerArcLayer *m_avgSinnerArcLayer;


-(void)drawSpeedMeterWithMaxValue:(float)maxValue;
-(void)initSpeedMeterWithBgStartDegree:(CGFloat)bgStartDegree withBgEndDegree:(CGFloat)bgEndDegree;
-(void)setSpinnerValiueWithInstantValue:(CGFloat)instantSpinnerValue withAvgValue:(CGFloat)avgSpinnerValue;
@end
