//
//  TestGaugeView.m
//  SKCore
//
//  Created by jungeol.park on 2014. 9. 4..
//  Copyright (c) 2014 ACCVUER. All rights reserved.
//

#import "SpeedMeterView.h"

@implementation SpeedMeterView

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // Initialization code
        self.m_isInited = NO;
    }
    return self;
}

- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super initWithCoder:aDecoder];
    if (self) {
        // Initialization code
        self.m_isInited = NO;
    }
    return self;
}

#pragma mark - init
-(void)drawSpeedMeterWithMaxValue:(float)maxValue
{
    self.m_maxValue = maxValue;
    
    [self setNeedsDisplay];
}

-(void)initSpeedMeterWithBgStartDegree:(CGFloat)bgStartDegree withBgEndDegree:(CGFloat)bgEndDegree
{
    self.m_isInited = YES;
    
    m_width = self.bounds.size.width;
    m_height = self.bounds.size.height;
    m_center = CGPointMake(m_width, m_height/2);
    m_radius = m_height / 2 * 0.9;
    
    self.m_minValue = 0;
    self.m_maxValue = 100;
    
    m_bgStartDegree = bgStartDegree;
    m_bgEndDegree = bgEndDegree;
    m_bgStartAngle = DEGREES_TO_RADIANS(m_bgStartDegree);
    m_bgEndAngle = DEGREES_TO_RADIANS(m_bgEndDegree);
    
    [self setBackgroundColor:COLOR_VIEW_BG];
    
    [self setNeedsDisplay];
    
    
    if(self.m_containerLayer == nil)
    {
        self.m_containerLayer = [CALayer layer];
        
        self.m_containerLayer.frame = CGRectMake(0, 0, m_width, m_height);
        [self.layer insertSublayer:self.m_containerLayer atIndex:0];
        [self initSpinnerArcLayers];
    }
}

- (void)initSpinnerArcLayers
{
    CGPoint center = CGPointMake(self.m_containerLayer.bounds.size.width, self.m_containerLayer.bounds.size.height/2);
    CGFloat radius = self.m_containerLayer.bounds.size.height / 2 * 0.9;
    
    self.m_avgSinnerArcLayer = [SpinnerArcLayer layer];
    self.m_avgSinnerArcLayer.m_startAngle = DEGREES_TO_RADIANS(90);
    self.m_avgSinnerArcLayer.m_endAngle = DEGREES_TO_RADIANS(90);
    self.m_avgSinnerArcLayer.m_fillColor = COLOR_PIN_AVERAGE_1;
    self.m_avgSinnerArcLayer.m_strokeColor = COLOR_PIN_AVERAGE_1;
    self.m_avgSinnerArcLayer.bounds = self.m_containerLayer.bounds;
    self.m_avgSinnerArcLayer.anchorPoint = CGPointZero;
    self.m_avgSinnerArcLayer.m_center = center;
    self.m_avgSinnerArcLayer.m_outerRadius = radius * 0.9;
    self.m_avgSinnerArcLayer.m_innerRadius = radius * 0.19+2;
    self.m_avgSinnerArcLayer.m_isAvgSpinner = YES;
    self.m_avgSinnerArcLayer.opacity = 0.85;
    if ( [self.m_avgSinnerArcLayer respondsToSelector:@selector(contentsScale)] )
    {
        self.m_avgSinnerArcLayer.contentsScale = [[UIScreen mainScreen] scale];
    }
    [self.m_containerLayer addSublayer:self.m_avgSinnerArcLayer];
    
    
    self.m_instantSpinnerArcLayer = [SpinnerArcLayer layer];
    self.m_instantSpinnerArcLayer.m_startAngle = DEGREES_TO_RADIANS(90);
    self.m_instantSpinnerArcLayer.m_endAngle = DEGREES_TO_RADIANS(90);
    self.m_instantSpinnerArcLayer.m_fillColor = [UIColor clearColor];
    self.m_instantSpinnerArcLayer.m_strokeColor = COLOR_PIN_INSTANT;
    self.m_instantSpinnerArcLayer.bounds = self.m_containerLayer.bounds;
    self.m_instantSpinnerArcLayer.anchorPoint = CGPointZero;
    self.m_instantSpinnerArcLayer.m_center = center;
    self.m_instantSpinnerArcLayer.m_outerRadius = radius * 0.97 ;
    self.m_instantSpinnerArcLayer.m_innerRadius = radius * 0.19;
    self.m_instantSpinnerArcLayer.m_isAvgSpinner = NO;
    
    self.m_instantSpinnerArcLayer.opacity = 1;
    if ( [self.m_instantSpinnerArcLayer respondsToSelector:@selector(contentsScale)] )
    {
        self.m_instantSpinnerArcLayer.contentsScale = [[UIScreen mainScreen] scale];
    }
    [self.m_containerLayer addSublayer:self.m_instantSpinnerArcLayer];

}


#pragma mark - setters
-(void)updateMaxValueWithInstantSpinnerValue:(double)instantSpinnerValue
{
    if(instantSpinnerValue > self.m_maxValue)
    {
        self.m_maxValue = instantSpinnerValue * (double)1.2f;
        [self setNeedsDisplay];
    }
}


- (void)setM_minValue:(float)minValue
{
    if ( _m_minValue != minValue )
    {
        minValue = minValue > _m_maxValue ? _m_maxValue : minValue;
        _m_minValue = minValue;
    }
}

- (void)setM_maxValue:(float)maxValue
{
    if ( _m_maxValue != maxValue )
    {
        maxValue = maxValue < _m_minValue ? _m_minValue : maxValue;
        _m_maxValue = maxValue;
    }
}

-(void)setSpinnerValiueWithInstantValue:(CGFloat)instantSpinnerValue withAvgValue:(CGFloat)avgSpinnerValue
{
    [self updateMaxValueWithInstantSpinnerValue:instantSpinnerValue];
    CGFloat instantSpinnerDegree = [self degreeForValue:instantSpinnerValue];
    CGFloat avgSpinnerDegree = [self degreeForValue:avgSpinnerValue];
    
    [self doSpinInstantSpinnerWithDegree:instantSpinnerDegree];
    [self doSpinAvgSpinnerWithDegree:avgSpinnerDegree];
}

- (float)degreeForValue:(float)value
{
    value = value > _m_maxValue ? _m_maxValue : value;
    value = value < _m_minValue ? _m_minValue : value;
    
    float ratio = (value - _m_minValue) / (_m_maxValue - _m_minValue);
    float angle = m_bgStartDegree + ((m_bgEndDegree - m_bgStartDegree) * ratio);
    return angle;
}

#pragma mark - spin spinner
- (void)doSpinInstantSpinnerWithDegree:(float)degree
{
    if ( _m_instantSpinnerArcLayer )
    {
        _m_instantSpinnerArcLayer.m_endAngle = DEGREES_TO_RADIANS((degree));
    }
}

- (void)doSpinAvgSpinnerWithDegree:(float)degree
{
    if ( _m_avgSinnerArcLayer )
    {
        _m_avgSinnerArcLayer.m_endAngle = DEGREES_TO_RADIANS((degree));
    }
}


#pragma mark - draw
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect
{
    NSLog(@"-------------drawRect-------------");
    // Drawing code
    CGContextRef ctx = UIGraphicsGetCurrentContext();
    [self draw_background:ctx withRect:rect];
    

}

#pragma mark - background drawing
-(void)draw_background:(CGContextRef)ctx withRect:(CGRect)rect
{
    [self draw_gradientBackground:ctx];
    [self draw_delimitersArc:ctx];
    [self draw_innerArc:ctx];
    [self draw_outerArc:ctx];
    [self draw_TextEachValue:ctx];
}

-(void)draw_gradientBackground:(CGContextRef)ctx
{
    size_t num_locations = 2;
    CGFloat locations[2] = { 0.0, 1.0 };
    CGFloat components[8] = { RGBIntToDouble(42), RGBIntToDouble(103), RGBIntToDouble(192), 1.0,  // Start color
        RGBIntToDouble(0), RGBIntToDouble(154), RGBIntToDouble(224), 1.0 }; // End color
    CGColorSpaceRef colorspace = CGColorSpaceCreateDeviceRGB();
    CGGradientRef gradient = CGGradientCreateWithColorComponents (colorspace, components, locations, num_locations);
    CGColorSpaceRelease(colorspace);
    
    CGContextDrawRadialGradient(ctx, gradient, m_center, m_radius /10 * 2, m_center, m_radius, 0);
    CGGradientRelease(gradient);
}

-(void)draw_delimitersArc:(CGContextRef)ctx
{
    CGFloat x1 = 0.0f, x2 = 0.0f, y1 = 0.0f, y2 = 0.0f;
    CGFloat r1 = 0.0f, r2 = 0.0f;
    
    r1 = m_radius * 0.9;
    r2 = m_radius * 0.81;
    
    for (int angle = m_bgStartDegree; angle <= m_bgEndDegree; angle += 5)
    {
        x1 = (m_width + r1 * cosf(DEGREES_TO_RADIANS(angle)));
        y1 = (m_center.y + r1 * sin(DEGREES_TO_RADIANS(angle)));
        x2 = (m_width + r2 * cosf(DEGREES_TO_RADIANS(angle)));
        y2 = (m_center.y + r2 * sin(DEGREES_TO_RADIANS(angle)));
        
        CGContextSetStrokeColorWithColor(ctx, [COLOR_DELIMITER CGColor]);
        CGContextSetLineWidth(ctx, 1.2);
        CGContextMoveToPoint(ctx, x1, y1);
        CGContextAddLineToPoint(ctx, x2, y2);
        CGContextStrokePath(ctx);
    }
    
    CGContextAddArc(ctx, m_center.x, m_center.y, r1+1.2, m_bgStartAngle, m_bgEndAngle, NO);
    CGContextAddArc(ctx, m_center.x, m_center.y, r1, m_bgEndAngle, m_bgStartAngle, YES);
    CGContextSetFillColorWithColor(ctx, [COLOR_DELIMITER CGColor]);
    CGContextSetLineWidth(ctx, 0);
    CGContextDrawPath(ctx, kCGPathFillStroke);
    
    CGContextMoveToPoint(ctx, m_center.x, m_center.y);
    CGContextAddLineToPoint(ctx, m_center.x , m_center.y + m_radius*1.05);
    CGContextSetLineWidth(ctx, 9);
    CGContextDrawPath(ctx, kCGPathFillStroke);

}

-(void)draw_innerArc:(CGContextRef)ctx
{
    
    CGContextAddArc(ctx, m_center.x, m_center.y, m_radius * 0.18, m_bgStartAngle, m_bgEndAngle, NO);
    CGContextSetFillColorWithColor(ctx, [COLOR_INNER_ARC_2 CGColor]);
    CGContextSetLineWidth(ctx, 0);
    CGContextDrawPath(ctx, kCGPathFillStroke);
    
    CGContextAddArc(ctx, m_center.x, m_center.y, m_radius * 0.01, m_bgStartAngle, m_bgEndAngle, NO);
    CGContextSetFillColorWithColor(ctx, [COLOR_INNER_ARC_3 CGColor]);
    CGContextSetLineWidth(ctx, 0);
    CGContextDrawPath(ctx, kCGPathFillStroke);
    
    CGContextAddArc(ctx, m_center.x, m_center.y, m_radius * 0.19, m_bgStartAngle, m_bgEndAngle, NO);
    //    CGContextSetFillColorWithColor(ctx, [COLOR_INNER_ARC_1 CGColor]);
    CGContextSetStrokeColorWithColor(ctx, [COLOR_INNER_ARC_1 CGColor]);
    CGContextSetLineWidth(ctx, 4);
    //    CGContextDrawPath(ctx, kCGPathFillStroke);
    CGContextDrawPath(ctx, kCGPathStroke);
}

-(void)draw_outerArc:(CGContextRef)ctx
{
    CGContextAddArc(ctx, m_center.x, m_center.y, m_radius*1.08, m_bgStartAngle, m_bgEndAngle, NO);
    CGContextAddArc(ctx, m_center.x, m_center.y, m_radius*1.01, m_bgEndAngle, m_bgStartAngle, YES);
    CGContextSetFillColorWithColor(ctx, [COLOR_OUTER_ARC CGColor]);
    CGContextSetLineWidth(ctx, 0);
    CGContextDrawPath(ctx, kCGPathFillStroke);
}

-(void)draw_TextEachValue:(CGContextRef)ctx
{
    CGContextSetLineWidth(ctx, 1);
    CGContextSetFillColorWithColor(ctx, [COLOR_TEXT_MARK CGColor]);
//    UIFont *font = [UIFont systemFontOfSize:FONT_SIZE_DELIMITER];
    UIFont *font = [UIFont boldSystemFontOfSize:FONT_SIZE_DELIMITER];
    
    CGFloat x1 = 0.0f, y1 = 0.0f;
    CGFloat r1 = m_radius * 0.7;
    NSString *v = nil;
    
    for (int degree = m_bgStartDegree; degree <= m_bgEndDegree; degree += 30) {
        x1 = ((m_width - FONT_SIZE_DELIMITER  / 2) + r1 * cosf(DEGREES_TO_RADIANS(degree)));
        y1 = (m_center.y + r1 * sin(DEGREES_TO_RADIANS(degree)));
        v = [NSString stringWithFormat:@"%d", (int)((degree - m_bgStartDegree) * self.m_maxValue / 180)];
        
        CGPoint p = CGPointMake(x1, y1-font.pointSize/2);
        [v drawAtPoint:p withFont:font];
        
//        
//        CGRect rect = CGRectMake(x1, y1, 2, 2);
//        CGContextFillRect(ctx, rect);
//        CGContextStrokePath(ctx);
    }
}


@end
