//
//  SpinnerArcLayer.h
//  SKCore
//
//  Created by jungeol.park on 2014. 9. 4..
//  Copyright (c) 2014 ACCVUER. All rights reserved.
//

#import <QuartzCore/QuartzCore.h>

#define DEGREES_TO_RADIANS(angle) (angle * (M_PI/180))

#define COLOR_VIEW_BG UIColorFromIntRGB(0, 154, 224, 1)  
#define COLOR_INNER_ARC_1 UIColorFromIntRGB(255, 99, 0, 1) 
#define COLOR_INNER_ARC_2 UIColorFromIntRGB(254, 254, 254, 1) 
#define COLOR_INNER_ARC_3 UIColorFromIntRGB(145, 145, 145, 1) 
#define COLOR_DELIMITER COLOR_INNER_ARC_2 
#define COLOR_OUTER_ARC COLOR_INNER_ARC_2 
#define COLOR_PIN_INSTANT UIColorFromIntRGB(255, 99, 0, 1)  
#define COLOR_PIN_AVERAGE_1 UIColorFromIntRGB(255, 186, 46, 1)  
#define COLOR_PIN_AVERAGE_2 UIColorFromIntRGB(255, 211, 122, 1)  
#define COLOR_TEXT_MARK COLOR_INNER_ARC_2 
#define FONT_SIZE_DELIMITER 17.0f


@interface SpinnerArcLayer : CALayer

@property (nonatomic,assign) CGFloat m_startAngle;
@property (nonatomic,assign) CGFloat m_endAngle;
@property (nonatomic) UIColor *m_fillColor;
@property (nonatomic) UIColor *m_strokeColor;
@property (nonatomic) BOOL m_isAvgSpinner;
@property (nonatomic, assign) CGPoint m_center;
@property(nonatomic, assign) CGFloat m_outerRadius;
@property(nonatomic, assign) CGFloat m_innerRadius;
@end
