//
//  SpinnerArcLayer.m
//  SKCore
//
//  Created by jungeol.park on 2014. 9. 4..
//  Copyright (c) 2014 ACCVUER. All rights reserved.
//

#import "SpinnerArcLayer.h"

#define START_ANGLE_KEY @"m_startAngle"
#define END_ANGEL_KEY @"m_endAngle"

@implementation SpinnerArcLayer
@dynamic m_startAngle, m_endAngle;

+ (BOOL)needsDisplayForKey:(NSString *)key
{
    if ( [key isEqualToString:START_ANGLE_KEY] ||
        [key isEqualToString:END_ANGEL_KEY] )
    {
        return YES;
    }
    return [super needsDisplayForKey:key];
}

- (id)initWithLayer:(id)layer
{
    self = [super initWithLayer:layer];
    if ( self )
    {
        if ( [layer isKindOfClass:[SpinnerArcLayer class]] )
        {
            SpinnerArcLayer *otherLayer = (SpinnerArcLayer*)layer;
            self.m_startAngle = otherLayer.m_startAngle;
            self.m_endAngle = otherLayer.m_endAngle;
            self.m_fillColor = otherLayer.m_fillColor;
            self.m_strokeColor = otherLayer.m_strokeColor;
            self.m_center = otherLayer.m_center;
            self.m_outerRadius = otherLayer.m_outerRadius;
            self.m_innerRadius = otherLayer.m_innerRadius;
            self.m_isAvgSpinner = otherLayer.m_isAvgSpinner;
        }
    }
    return self;
}

- (id<CAAction>)actionForKey:(NSString *)event
{
    if ( [event isEqualToString:START_ANGLE_KEY] ||
        [event isEqualToString:END_ANGEL_KEY] )
    {
        return [self makeAnimationForKey:event];
    }
    
    return [super actionForKey:event];
}

- (CABasicAnimation*)makeAnimationForKey:(NSString *)key
{
	CABasicAnimation *anim = [CABasicAnimation animationWithKeyPath:key];
	anim.fromValue = [[self presentationLayer] valueForKey:key];
	anim.timingFunction = [CAMediaTimingFunction functionWithName:kCAMediaTimingFunctionEaseOut];
	anim.duration = 0.5;
    
	return anim;
}

- (void)drawInContext:(CGContextRef)ctx
{
    [self drawSpinnerArc:ctx];
    
    if(self.m_isAvgSpinner)
    {
        [self drawInnerArc:ctx];
    }
}

-(void)drawSpinnerArc:(CGContextRef)ctx
{
    if ( self.m_startAngle < self.m_endAngle )
    {
        CGContextBeginPath(ctx);
        
        //outer arc
        CGContextAddArc(ctx, self.m_center.x, self.m_center.y, self.m_outerRadius, self.m_startAngle, self.m_endAngle, NO);
        
        //inner arc
        if(self.m_isAvgSpinner)
            CGContextAddArc(ctx, self.m_center.x, self.m_center.y, self.m_innerRadius * 1.07, self.m_endAngle, self.m_startAngle, YES);
        else
            CGContextAddArc(ctx, self.m_center.x, self.m_center.y, self.m_innerRadius, self.m_endAngle, self.m_startAngle, YES);
        
        CGContextClosePath(ctx);
        
        CGContextSetFillColorWithColor(ctx, [self.m_fillColor CGColor]);
        CGContextSetStrokeColorWithColor(ctx, [self.m_strokeColor CGColor]);
        CGContextSetLineWidth(ctx, 4);
        
        CGContextDrawPath(ctx, kCGPathFillStroke);
    }
}

-(void)drawInnerArc:(CGContextRef)ctx
{
    if ( self.m_startAngle < self.m_endAngle )
    {
        CGContextBeginPath(ctx);
        
        //outer arc
        CGContextAddArc(ctx, self.m_center.x, self.m_center.y, self.m_outerRadius * 0.87, self.m_startAngle, self.m_endAngle, NO);
        
        //endAngle line
        CGContextAddLineToPoint(ctx, self.m_center.x + (self.m_innerRadius* 1.07 - 2) * cos(self.m_endAngle), self.m_center.y + (self.m_innerRadius * 1.07 - 2) * sin(self.m_endAngle));
        
        //inner arc
//        CGContextAddArc(ctx, self.m_center.x, self.m_center.y, self.m_innerRadius* 1.07+2, self.m_endAngle, self.m_startAngle, YES);
//        CGContextClosePath(ctx);
        
        CGContextSetFillColorWithColor(ctx, [[UIColor clearColor] CGColor]);
        CGContextSetStrokeColorWithColor(ctx, [COLOR_PIN_AVERAGE_2 CGColor]);
        CGContextSetLineWidth(ctx, 4);
        
        CGContextDrawPath(ctx, kCGPathFillStroke);
    }
}

@end
