//
//  TestResultDataCollector.h
//  SKCore
//
//  Created by jungeol.park on 2014. 10. 1..
//  Copyright (c) 2014 ACCVUER. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "../3rdParty/GoldRaccoon/GRRequestsManager.h"

#define TEST_RESULT_UNKNOW_VALUE_DOUBLE_TYPE -DBL_MAX
#define TEST_RESULT_FAILED_VALUE_DOUBLE_TYPE DBL_MAX
#define TEST_RESULT_UNKNOW_VALUE_int_TYPE INT_MIN
#define TEST_RESULT_FAILED_VALUE_int_TYPE INT_MAX
#define TEST_RESULT_UNKNOW_VALUE_NSUInteger_TYPE NSUIntegerMax
#define TEST_RESULT_FAILED_VALUE_NSUInteger_TYPE (NSUIntegerMax - 1)


@interface TestResultDataCollector : NSObject <GRRequestsManagerDelegate>
{
    NSDictionary *m_japanOperatorDic;
}

@property (nonatomic, strong) GRRequestsManager *requestsManager;
@property (nonatomic) BOOL isAutoRepeat;

// common result
@property (nonatomic, strong) NSString *StartTime;
@property (nonatomic, strong) NSString *EndTime;
@property (nonatomic, assign) double Latency;
@property (nonatomic, assign) double Packet_Loss;
@property (nonatomic, assign) double Max_DL_Throughput;
@property (nonatomic, assign) double Max_UL_Throughput;
@property (nonatomic, strong) NSMutableArray *Avg_DL_Throughput;    // double
@property (nonatomic, strong) NSMutableArray *Avg_UL_Throughput;    // double

// GET result
@property (nonatomic, strong) NSMutableArray *GET_result;           // NSString
@property (nonatomic, strong) NSString *GET_thread;
@property (nonatomic, strong) NSMutableArray *GET_warmup_Bytes;     // NSUInteger
@property (nonatomic, strong) NSMutableArray *GET_warmup_time;      // double
@property (nonatomic, strong) NSMutableArray *GET_Byte_sec;         // int
@property (nonatomic, strong) NSMutableArray *GET_Transfer_Time;    // double
@property (nonatomic, strong) NSMutableArray *GET_Byte_Total;       // NSUInteger

// POST result
@property (nonatomic, strong) NSMutableArray *POST_result;          // NSString
@property (nonatomic, strong) NSString *POST_thread;
@property (nonatomic, strong) NSMutableArray *POST_warmup_bytes;    // NSUInteger
@property (nonatomic, strong) NSMutableArray *POST_warmup_time;     // double
@property (nonatomic, strong) NSMutableArray *POST_Byte_sec;        // int
@property (nonatomic, strong) NSMutableArray *POST_Transfer_Time;   // double
@property (nonatomic, strong) NSMutableArray *POST_Byte_Total;      // NSUInteger

@property (nonatomic, strong) NSString *RTT_Result;
@property (nonatomic, assign) double RTT_AVG;
@property (nonatomic, assign) double RTT_MIN;
@property (nonatomic, assign) double RTT_MAX;
@property (nonatomic, assign) double RTT_STDDEV;
@property (nonatomic, assign) int Received_packets;
@property (nonatomic, assign) int Lost_packet;


+(TestResultDataCollector *)sharedInstance;

-(void)initResultData;
-(void) doProcessFinalResultWithDBIndex:(NSNumber*)testId;

@end
